package computenestsupplier

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateArtifact invokes the computenestsupplier.UpdateArtifact API synchronously
func (client *Client) UpdateArtifact(request *UpdateArtifactRequest) (response *UpdateArtifactResponse, err error) {
	response = CreateUpdateArtifactResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateArtifactWithChan invokes the computenestsupplier.UpdateArtifact API asynchronously
func (client *Client) UpdateArtifactWithChan(request *UpdateArtifactRequest) (<-chan *UpdateArtifactResponse, <-chan error) {
	responseChan := make(chan *UpdateArtifactResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateArtifact(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateArtifactWithCallback invokes the computenestsupplier.UpdateArtifact API asynchronously
func (client *Client) UpdateArtifactWithCallback(request *UpdateArtifactRequest, callback func(response *UpdateArtifactResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateArtifactResponse
		var err error
		defer close(result)
		response, err = client.UpdateArtifact(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateArtifactRequest is the request struct for api UpdateArtifact
type UpdateArtifactRequest struct {
	*requests.RpcRequest
	Description      string    `position:"Query" name:"Description"`
	SupportRegionIds *[]string `position:"Query" name:"SupportRegionIds"  type:"Repeated"`
	ArtifactId       string    `position:"Query" name:"ArtifactId"`
	ArtifactProperty string    `position:"Query" name:"ArtifactProperty"`
	VersionName      string    `position:"Query" name:"VersionName"`
}

// UpdateArtifactResponse is the response struct for api UpdateArtifact
type UpdateArtifactResponse struct {
	*responses.BaseResponse
	RequestId        string `json:"RequestId" xml:"RequestId"`
	ArtifactId       string `json:"ArtifactId" xml:"ArtifactId"`
	ArtifactType     string `json:"ArtifactType" xml:"ArtifactType"`
	VersionName      string `json:"VersionName" xml:"VersionName"`
	ArtifactVersion  string `json:"ArtifactVersion" xml:"ArtifactVersion"`
	Description      string `json:"Description" xml:"Description"`
	GmtModified      string `json:"GmtModified" xml:"GmtModified"`
	Status           string `json:"Status" xml:"Status"`
	ArtifactProperty string `json:"ArtifactProperty" xml:"ArtifactProperty"`
	SupportRegionIds string `json:"SupportRegionIds" xml:"SupportRegionIds"`
}

// CreateUpdateArtifactRequest creates a request to invoke UpdateArtifact API
func CreateUpdateArtifactRequest() (request *UpdateArtifactRequest) {
	request = &UpdateArtifactRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNestSupplier", "2021-05-21", "UpdateArtifact", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateArtifactResponse creates a response to parse from UpdateArtifact response
func CreateUpdateArtifactResponse() (response *UpdateArtifactResponse) {
	response = &UpdateArtifactResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
