package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMetricRuleBlackList invokes the cms.DescribeMetricRuleBlackList API synchronously
func (client *Client) DescribeMetricRuleBlackList(request *DescribeMetricRuleBlackListRequest) (response *DescribeMetricRuleBlackListResponse, err error) {
	response = CreateDescribeMetricRuleBlackListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMetricRuleBlackListWithChan invokes the cms.DescribeMetricRuleBlackList API asynchronously
func (client *Client) DescribeMetricRuleBlackListWithChan(request *DescribeMetricRuleBlackListRequest) (<-chan *DescribeMetricRuleBlackListResponse, <-chan error) {
	responseChan := make(chan *DescribeMetricRuleBlackListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMetricRuleBlackList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMetricRuleBlackListWithCallback invokes the cms.DescribeMetricRuleBlackList API asynchronously
func (client *Client) DescribeMetricRuleBlackListWithCallback(request *DescribeMetricRuleBlackListRequest, callback func(response *DescribeMetricRuleBlackListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMetricRuleBlackListResponse
		var err error
		defer close(result)
		response, err = client.DescribeMetricRuleBlackList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMetricRuleBlackListRequest is the request struct for api DescribeMetricRuleBlackList
type DescribeMetricRuleBlackListRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	Namespace  string           `position:"Query" name:"Namespace"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	Ids        *[]string        `position:"Query" name:"Ids"  type:"Repeated"`
	Category   string           `position:"Query" name:"Category"`
	Order      requests.Integer `position:"Query" name:"Order"`
}

// DescribeMetricRuleBlackListResponse is the response struct for api DescribeMetricRuleBlackList
type DescribeMetricRuleBlackListResponse struct {
	*responses.BaseResponse
	Code                        string                            `json:"Code" xml:"Code"`
	Message                     string                            `json:"Message" xml:"Message"`
	RequestId                   string                            `json:"RequestId" xml:"RequestId"`
	Total                       int                               `json:"Total" xml:"Total"`
	Success                     bool                              `json:"Success" xml:"Success"`
	DescribeMetricRuleBlackList []DescribeMetricRuleBlackListItem `json:"DescribeMetricRuleBlackList" xml:"DescribeMetricRuleBlackList"`
}

// CreateDescribeMetricRuleBlackListRequest creates a request to invoke DescribeMetricRuleBlackList API
func CreateDescribeMetricRuleBlackListRequest() (request *DescribeMetricRuleBlackListRequest) {
	request = &DescribeMetricRuleBlackListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeMetricRuleBlackList", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMetricRuleBlackListResponse creates a response to parse from DescribeMetricRuleBlackList response
func CreateDescribeMetricRuleBlackListResponse() (response *DescribeMetricRuleBlackListResponse) {
	response = &DescribeMetricRuleBlackListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
