package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ShopGetredress invokes the cloudwf.ShopGetredress API synchronously
// api document: https://help.aliyun.com/api/cloudwf/shopgetredress.html
func (client *Client) ShopGetredress(request *ShopGetredressRequest) (response *ShopGetredressResponse, err error) {
	response = CreateShopGetredressResponse()
	err = client.DoAction(request, response)
	return
}

// ShopGetredressWithChan invokes the cloudwf.ShopGetredress API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopgetredress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopGetredressWithChan(request *ShopGetredressRequest) (<-chan *ShopGetredressResponse, <-chan error) {
	responseChan := make(chan *ShopGetredressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ShopGetredress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ShopGetredressWithCallback invokes the cloudwf.ShopGetredress API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopgetredress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopGetredressWithCallback(request *ShopGetredressRequest, callback func(response *ShopGetredressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ShopGetredressResponse
		var err error
		defer close(result)
		response, err = client.ShopGetredress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ShopGetredressRequest is the request struct for api ShopGetredress
type ShopGetredressRequest struct {
	*requests.RpcRequest
	Sid requests.Integer `position:"Query" name:"Sid"`
}

// ShopGetredressResponse is the response struct for api ShopGetredress
type ShopGetredressResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateShopGetredressRequest creates a request to invoke ShopGetredress API
func CreateShopGetredressRequest() (request *ShopGetredressRequest) {
	request = &ShopGetredressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ShopGetredress", "cloudwf", "openAPI")
	return
}

// CreateShopGetredressResponse creates a response to parse from ShopGetredress response
func CreateShopGetredressResponse() (response *ShopGetredressResponse) {
	response = &ShopGetredressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
