package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SyncAddMaterial invokes the cloudesl.SyncAddMaterial API synchronously
func (client *Client) SyncAddMaterial(request *SyncAddMaterialRequest) (response *SyncAddMaterialResponse, err error) {
	response = CreateSyncAddMaterialResponse()
	err = client.DoAction(request, response)
	return
}

// SyncAddMaterialWithChan invokes the cloudesl.SyncAddMaterial API asynchronously
func (client *Client) SyncAddMaterialWithChan(request *SyncAddMaterialRequest) (<-chan *SyncAddMaterialResponse, <-chan error) {
	responseChan := make(chan *SyncAddMaterialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SyncAddMaterial(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SyncAddMaterialWithCallback invokes the cloudesl.SyncAddMaterial API asynchronously
func (client *Client) SyncAddMaterialWithCallback(request *SyncAddMaterialRequest, callback func(response *SyncAddMaterialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SyncAddMaterialResponse
		var err error
		defer close(result)
		response, err = client.SyncAddMaterial(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SyncAddMaterialRequest is the request struct for api SyncAddMaterial
type SyncAddMaterialRequest struct {
	*requests.RpcRequest
	Content string `position:"Body" name:"Content"`
	Name    string `position:"Body" name:"Name"`
}

// SyncAddMaterialResponse is the response struct for api SyncAddMaterial
type SyncAddMaterialResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Message        string `json:"Message" xml:"Message"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code           string `json:"Code" xml:"Code"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Result         Result `json:"Result" xml:"Result"`
}

// CreateSyncAddMaterialRequest creates a request to invoke SyncAddMaterial API
func CreateSyncAddMaterialRequest() (request *SyncAddMaterialRequest) {
	request = &SyncAddMaterialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "SyncAddMaterial", "", "")
	request.Method = requests.POST
	return
}

// CreateSyncAddMaterialResponse creates a response to parse from SyncAddMaterial response
func CreateSyncAddMaterialResponse() (response *SyncAddMaterialResponse) {
	response = &SyncAddMaterialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
