package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveLayout invokes the cloudesl.SaveLayout API synchronously
func (client *Client) SaveLayout(request *SaveLayoutRequest) (response *SaveLayoutResponse, err error) {
	response = CreateSaveLayoutResponse()
	err = client.DoAction(request, response)
	return
}

// SaveLayoutWithChan invokes the cloudesl.SaveLayout API asynchronously
func (client *Client) SaveLayoutWithChan(request *SaveLayoutRequest) (<-chan *SaveLayoutResponse, <-chan error) {
	responseChan := make(chan *SaveLayoutResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveLayout(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveLayoutWithCallback invokes the cloudesl.SaveLayout API asynchronously
func (client *Client) SaveLayoutWithCallback(request *SaveLayoutRequest, callback func(response *SaveLayoutResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveLayoutResponse
		var err error
		defer close(result)
		response, err = client.SaveLayout(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveLayoutRequest is the request struct for api SaveLayout
type SaveLayoutRequest struct {
	*requests.RpcRequest
	LayoutId        string `position:"Body" name:"LayoutId"`
	TemplateVersion string `position:"Body" name:"TemplateVersion"`
	LayoutName      string `position:"Body" name:"LayoutName"`
	EslModelId      string `position:"Body" name:"EslModelId"`
}

// SaveLayoutResponse is the response struct for api SaveLayout
type SaveLayoutResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Message        string `json:"Message" xml:"Message"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code           string `json:"Code" xml:"Code"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
}

// CreateSaveLayoutRequest creates a request to invoke SaveLayout API
func CreateSaveLayoutRequest() (request *SaveLayoutRequest) {
	request = &SaveLayoutRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "SaveLayout", "", "")
	request.Method = requests.POST
	return
}

// CreateSaveLayoutResponse creates a response to parse from SaveLayout response
func CreateSaveLayoutResponse() (response *SaveLayoutResponse) {
	response = &SaveLayoutResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
