package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEslModelByTemplateVersion invokes the cloudesl.DescribeEslModelByTemplateVersion API synchronously
func (client *Client) DescribeEslModelByTemplateVersion(request *DescribeEslModelByTemplateVersionRequest) (response *DescribeEslModelByTemplateVersionResponse, err error) {
	response = CreateDescribeEslModelByTemplateVersionResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEslModelByTemplateVersionWithChan invokes the cloudesl.DescribeEslModelByTemplateVersion API asynchronously
func (client *Client) DescribeEslModelByTemplateVersionWithChan(request *DescribeEslModelByTemplateVersionRequest) (<-chan *DescribeEslModelByTemplateVersionResponse, <-chan error) {
	responseChan := make(chan *DescribeEslModelByTemplateVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEslModelByTemplateVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEslModelByTemplateVersionWithCallback invokes the cloudesl.DescribeEslModelByTemplateVersion API asynchronously
func (client *Client) DescribeEslModelByTemplateVersionWithCallback(request *DescribeEslModelByTemplateVersionRequest, callback func(response *DescribeEslModelByTemplateVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEslModelByTemplateVersionResponse
		var err error
		defer close(result)
		response, err = client.DescribeEslModelByTemplateVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEslModelByTemplateVersionRequest is the request struct for api DescribeEslModelByTemplateVersion
type DescribeEslModelByTemplateVersionRequest struct {
	*requests.RpcRequest
	PageNumber      requests.Integer `position:"Body" name:"PageNumber"`
	TemplateVersion string           `position:"Body" name:"TemplateVersion"`
	PageSize        requests.Integer `position:"Body" name:"PageSize"`
}

// DescribeEslModelByTemplateVersionResponse is the response struct for api DescribeEslModelByTemplateVersion
type DescribeEslModelByTemplateVersionResponse struct {
	*responses.BaseResponse
	TotalCount     int              `json:"TotalCount" xml:"TotalCount"`
	RequestId      string           `json:"RequestId" xml:"RequestId"`
	ErrorMessage   string           `json:"ErrorMessage" xml:"ErrorMessage"`
	Success        bool             `json:"Success" xml:"Success"`
	ErrorCode      string           `json:"ErrorCode" xml:"ErrorCode"`
	Code           string           `json:"Code" xml:"Code"`
	Message        string           `json:"Message" xml:"Message"`
	DynamicMessage string           `json:"DynamicMessage" xml:"DynamicMessage"`
	DynamicCode    string           `json:"DynamicCode" xml:"DynamicCode"`
	PageNumber     int              `json:"PageNumber" xml:"PageNumber"`
	PageSize       int              `json:"PageSize" xml:"PageSize"`
	EslModels      []SelectItemInfo `json:"EslModels" xml:"EslModels"`
}

// CreateDescribeEslModelByTemplateVersionRequest creates a request to invoke DescribeEslModelByTemplateVersion API
func CreateDescribeEslModelByTemplateVersionRequest() (request *DescribeEslModelByTemplateVersionRequest) {
	request = &DescribeEslModelByTemplateVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "DescribeEslModelByTemplateVersion", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeEslModelByTemplateVersionResponse creates a response to parse from DescribeEslModelByTemplateVersion response
func CreateDescribeEslModelByTemplateVersionResponse() (response *DescribeEslModelByTemplateVersionResponse) {
	response = &DescribeEslModelByTemplateVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
