package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyUserEx invokes the cloudcallcenter.ModifyUserEx API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyuserex.html
func (client *Client) ModifyUserEx(request *ModifyUserExRequest) (response *ModifyUserExResponse, err error) {
	response = CreateModifyUserExResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyUserExWithChan invokes the cloudcallcenter.ModifyUserEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyuserex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyUserExWithChan(request *ModifyUserExRequest) (<-chan *ModifyUserExResponse, <-chan error) {
	responseChan := make(chan *ModifyUserExResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyUserEx(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyUserExWithCallback invokes the cloudcallcenter.ModifyUserEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyuserex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyUserExWithCallback(request *ModifyUserExRequest, callback func(response *ModifyUserExResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyUserExResponse
		var err error
		defer close(result)
		response, err = client.ModifyUserEx(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyUserExRequest is the request struct for api ModifyUserEx
type ModifyUserExRequest struct {
	*requests.RpcRequest
	SkillLevel   *[]string `position:"Query" name:"SkillLevel"  type:"Repeated"`
	InstanceId   string    `position:"Query" name:"InstanceId"`
	RoleId       *[]string `position:"Query" name:"RoleId"  type:"Repeated"`
	SkillGroupId *[]string `position:"Query" name:"SkillGroupId"  type:"Repeated"`
	UserId       string    `position:"Query" name:"UserId"`
}

// ModifyUserExResponse is the response struct for api ModifyUserEx
type ModifyUserExResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateModifyUserExRequest creates a request to invoke ModifyUserEx API
func CreateModifyUserExRequest() (request *ModifyUserExRequest) {
	request = &ModifyUserExRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ModifyUserEx", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyUserExResponse creates a response to parse from ModifyUserEx response
func CreateModifyUserExResponse() (response *ModifyUserExResponse) {
	response = &ModifyUserExResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
