package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUnrecognizedIntents invokes the cloudcallcenter.ListUnrecognizedIntents API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listunrecognizedintents.html
func (client *Client) ListUnrecognizedIntents(request *ListUnrecognizedIntentsRequest) (response *ListUnrecognizedIntentsResponse, err error) {
	response = CreateListUnrecognizedIntentsResponse()
	err = client.DoAction(request, response)
	return
}

// ListUnrecognizedIntentsWithChan invokes the cloudcallcenter.ListUnrecognizedIntents API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listunrecognizedintents.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListUnrecognizedIntentsWithChan(request *ListUnrecognizedIntentsRequest) (<-chan *ListUnrecognizedIntentsResponse, <-chan error) {
	responseChan := make(chan *ListUnrecognizedIntentsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUnrecognizedIntents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUnrecognizedIntentsWithCallback invokes the cloudcallcenter.ListUnrecognizedIntents API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listunrecognizedintents.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListUnrecognizedIntentsWithCallback(request *ListUnrecognizedIntentsRequest, callback func(response *ListUnrecognizedIntentsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUnrecognizedIntentsResponse
		var err error
		defer close(result)
		response, err = client.ListUnrecognizedIntents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUnrecognizedIntentsRequest is the request struct for api ListUnrecognizedIntents
type ListUnrecognizedIntentsRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	JobGroupId string           `position:"Query" name:"JobGroupId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListUnrecognizedIntentsResponse is the response struct for api ListUnrecognizedIntents
type ListUnrecognizedIntentsResponse struct {
	*responses.BaseResponse
	RequestId      string  `json:"RequestId" xml:"RequestId"`
	Success        bool    `json:"Success" xml:"Success"`
	Code           string  `json:"Code" xml:"Code"`
	Message        string  `json:"Message" xml:"Message"`
	HttpStatusCode int     `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Intents        Intents `json:"Intents" xml:"Intents"`
}

// CreateListUnrecognizedIntentsRequest creates a request to invoke ListUnrecognizedIntents API
func CreateListUnrecognizedIntentsRequest() (request *ListUnrecognizedIntentsRequest) {
	request = &ListUnrecognizedIntentsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListUnrecognizedIntents", "", "")
	request.Method = requests.POST
	return
}

// CreateListUnrecognizedIntentsResponse creates a response to parse from ListUnrecognizedIntents response
func CreateListUnrecognizedIntentsResponse() (response *ListUnrecognizedIntentsResponse) {
	response = &ListUnrecognizedIntentsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
