package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBarCharts invokes the cloudcallcenter.ListBarCharts API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listbarcharts.html
func (client *Client) ListBarCharts(request *ListBarChartsRequest) (response *ListBarChartsResponse, err error) {
	response = CreateListBarChartsResponse()
	err = client.DoAction(request, response)
	return
}

// ListBarChartsWithChan invokes the cloudcallcenter.ListBarCharts API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listbarcharts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListBarChartsWithChan(request *ListBarChartsRequest) (<-chan *ListBarChartsResponse, <-chan error) {
	responseChan := make(chan *ListBarChartsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBarCharts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBarChartsWithCallback invokes the cloudcallcenter.ListBarCharts API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listbarcharts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListBarChartsWithCallback(request *ListBarChartsRequest, callback func(response *ListBarChartsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBarChartsResponse
		var err error
		defer close(result)
		response, err = client.ListBarCharts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBarChartsRequest is the request struct for api ListBarCharts
type ListBarChartsRequest struct {
	*requests.RpcRequest
	Date          string    `position:"Query" name:"Date"`
	InstanceId    string    `position:"Query" name:"InstanceId"`
	Dimension     string    `position:"Query" name:"Dimension"`
	IndicatorName *[]string `position:"Query" name:"IndicatorName"  type:"Repeated"`
}

// ListBarChartsResponse is the response struct for api ListBarCharts
type ListBarChartsResponse struct {
	*responses.BaseResponse
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	Success        bool        `json:"Success" xml:"Success"`
	Code           string      `json:"Code" xml:"Code"`
	Message        string      `json:"Message" xml:"Message"`
	HttpStatusCode int         `json:"HttpStatusCode" xml:"HttpStatusCode"`
	TrendCharts    TrendCharts `json:"TrendCharts" xml:"TrendCharts"`
}

// CreateListBarChartsRequest creates a request to invoke ListBarCharts API
func CreateListBarChartsRequest() (request *ListBarChartsRequest) {
	request = &ListBarChartsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListBarCharts", "", "")
	request.Method = requests.POST
	return
}

// CreateListBarChartsResponse creates a response to parse from ListBarCharts response
func CreateListBarChartsResponse() (response *ListBarChartsResponse) {
	response = &ListBarChartsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
