package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSmsConfig invokes the cloudcallcenter.CreateSmsConfig API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createsmsconfig.html
func (client *Client) CreateSmsConfig(request *CreateSmsConfigRequest) (response *CreateSmsConfigResponse, err error) {
	response = CreateCreateSmsConfigResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSmsConfigWithChan invokes the cloudcallcenter.CreateSmsConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createsmsconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateSmsConfigWithChan(request *CreateSmsConfigRequest) (<-chan *CreateSmsConfigResponse, <-chan error) {
	responseChan := make(chan *CreateSmsConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSmsConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSmsConfigWithCallback invokes the cloudcallcenter.CreateSmsConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createsmsconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateSmsConfigWithCallback(request *CreateSmsConfigRequest, callback func(response *CreateSmsConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSmsConfigResponse
		var err error
		defer close(result)
		response, err = client.CreateSmsConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSmsConfigRequest is the request struct for api CreateSmsConfig
type CreateSmsConfigRequest struct {
	*requests.RpcRequest
	Description  string           `position:"Query" name:"Description"`
	SignName     string           `position:"Query" name:"SignName"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
	Scenario     requests.Integer `position:"Query" name:"Scenario"`
	Extra        string           `position:"Query" name:"Extra"`
	Name         string           `position:"Query" name:"Name"`
	Id           requests.Integer `position:"Query" name:"Id"`
	TemplateCode string           `position:"Query" name:"TemplateCode"`
}

// CreateSmsConfigResponse is the response struct for api CreateSmsConfig
type CreateSmsConfigResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Count          int    `json:"Count" xml:"Count"`
}

// CreateCreateSmsConfigRequest creates a request to invoke CreateSmsConfig API
func CreateCreateSmsConfigRequest() (request *CreateSmsConfigRequest) {
	request = &CreateSmsConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "CreateSmsConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateSmsConfigResponse creates a response to parse from CreateSmsConfig response
func CreateCreateSmsConfigResponse() (response *CreateSmsConfigResponse) {
	response = &CreateSmsConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
