package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AuditVnTTSVoice invokes the cloudcallcenter.AuditVnTTSVoice API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/auditvnttsvoice.html
func (client *Client) AuditVnTTSVoice(request *AuditVnTTSVoiceRequest) (response *AuditVnTTSVoiceResponse, err error) {
	response = CreateAuditVnTTSVoiceResponse()
	err = client.DoAction(request, response)
	return
}

// AuditVnTTSVoiceWithChan invokes the cloudcallcenter.AuditVnTTSVoice API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/auditvnttsvoice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AuditVnTTSVoiceWithChan(request *AuditVnTTSVoiceRequest) (<-chan *AuditVnTTSVoiceResponse, <-chan error) {
	responseChan := make(chan *AuditVnTTSVoiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AuditVnTTSVoice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AuditVnTTSVoiceWithCallback invokes the cloudcallcenter.AuditVnTTSVoice API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/auditvnttsvoice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AuditVnTTSVoiceWithCallback(request *AuditVnTTSVoiceRequest, callback func(response *AuditVnTTSVoiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AuditVnTTSVoiceResponse
		var err error
		defer close(result)
		response, err = client.AuditVnTTSVoice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AuditVnTTSVoiceRequest is the request struct for api AuditVnTTSVoice
type AuditVnTTSVoiceRequest struct {
	*requests.RpcRequest
	Voice      string `position:"Query" name:"Voice"`
	Volume     string `position:"Query" name:"Volume"`
	InstanceId string `position:"Query" name:"InstanceId"`
	Text       string `position:"Query" name:"Text"`
	SpeechRate string `position:"Query" name:"SpeechRate"`
}

// AuditVnTTSVoiceResponse is the response struct for api AuditVnTTSVoice
type AuditVnTTSVoiceResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	AuditionUrl string `json:"AuditionUrl" xml:"AuditionUrl"`
}

// CreateAuditVnTTSVoiceRequest creates a request to invoke AuditVnTTSVoice API
func CreateAuditVnTTSVoiceRequest() (request *AuditVnTTSVoiceRequest) {
	request = &AuditVnTTSVoiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "AuditVnTTSVoice", "", "")
	request.Method = requests.GET
	return
}

// CreateAuditVnTTSVoiceResponse creates a response to parse from AuditVnTTSVoice response
func CreateAuditVnTTSVoiceResponse() (response *AuditVnTTSVoiceResponse) {
	response = &AuditVnTTSVoiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
