package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MobileOnlineStatus invokes the cloudauth.MobileOnlineStatus API synchronously
func (client *Client) MobileOnlineStatus(request *MobileOnlineStatusRequest) (response *MobileOnlineStatusResponse, err error) {
	response = CreateMobileOnlineStatusResponse()
	err = client.DoAction(request, response)
	return
}

// MobileOnlineStatusWithChan invokes the cloudauth.MobileOnlineStatus API asynchronously
func (client *Client) MobileOnlineStatusWithChan(request *MobileOnlineStatusRequest) (<-chan *MobileOnlineStatusResponse, <-chan error) {
	responseChan := make(chan *MobileOnlineStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MobileOnlineStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MobileOnlineStatusWithCallback invokes the cloudauth.MobileOnlineStatus API asynchronously
func (client *Client) MobileOnlineStatusWithCallback(request *MobileOnlineStatusRequest, callback func(response *MobileOnlineStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MobileOnlineStatusResponse
		var err error
		defer close(result)
		response, err = client.MobileOnlineStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MobileOnlineStatusRequest is the request struct for api MobileOnlineStatus
type MobileOnlineStatusRequest struct {
	*requests.RpcRequest
	ParamType string `position:"Body" name:"ParamType"`
	Mobile    string `position:"Body" name:"Mobile"`
}

// MobileOnlineStatusResponse is the response struct for api MobileOnlineStatus
type MobileOnlineStatusResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Code         string       `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateMobileOnlineStatusRequest creates a request to invoke MobileOnlineStatus API
func CreateMobileOnlineStatusRequest() (request *MobileOnlineStatusRequest) {
	request = &MobileOnlineStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "MobileOnlineStatus", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMobileOnlineStatusResponse creates a response to parse from MobileOnlineStatus response
func CreateMobileOnlineStatusResponse() (response *MobileOnlineStatusResponse) {
	response = &MobileOnlineStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
