package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceDropPacket invokes the cloudapi.DescribeInstanceDropPacket API synchronously
func (client *Client) DescribeInstanceDropPacket(request *DescribeInstanceDropPacketRequest) (response *DescribeInstanceDropPacketResponse, err error) {
	response = CreateDescribeInstanceDropPacketResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceDropPacketWithChan invokes the cloudapi.DescribeInstanceDropPacket API asynchronously
func (client *Client) DescribeInstanceDropPacketWithChan(request *DescribeInstanceDropPacketRequest) (<-chan *DescribeInstanceDropPacketResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceDropPacketResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceDropPacket(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceDropPacketWithCallback invokes the cloudapi.DescribeInstanceDropPacket API asynchronously
func (client *Client) DescribeInstanceDropPacketWithCallback(request *DescribeInstanceDropPacketRequest, callback func(response *DescribeInstanceDropPacketResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceDropPacketResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceDropPacket(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceDropPacketRequest is the request struct for api DescribeInstanceDropPacket
type DescribeInstanceDropPacketRequest struct {
	*requests.RpcRequest
	EndTime       string `position:"Query" name:"EndTime"`
	StartTime     string `position:"Query" name:"StartTime"`
	SbcName       string `position:"Query" name:"SbcName"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// DescribeInstanceDropPacketResponse is the response struct for api DescribeInstanceDropPacket
type DescribeInstanceDropPacketResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	InstanceDropPacket InstanceDropPacket `json:"InstanceDropPacket" xml:"InstanceDropPacket"`
}

// CreateDescribeInstanceDropPacketRequest creates a request to invoke DescribeInstanceDropPacket API
func CreateDescribeInstanceDropPacketRequest() (request *DescribeInstanceDropPacketRequest) {
	request = &DescribeInstanceDropPacketRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeInstanceDropPacket", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceDropPacketResponse creates a response to parse from DescribeInstanceDropPacket response
func CreateDescribeInstanceDropPacketResponse() (response *DescribeInstanceDropPacketResponse) {
	response = &DescribeInstanceDropPacketResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
