package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAlertType invokes the cloud_siem.DescribeAlertType API synchronously
func (client *Client) DescribeAlertType(request *DescribeAlertTypeRequest) (response *DescribeAlertTypeResponse, err error) {
	response = CreateDescribeAlertTypeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAlertTypeWithChan invokes the cloud_siem.DescribeAlertType API asynchronously
func (client *Client) DescribeAlertTypeWithChan(request *DescribeAlertTypeRequest) (<-chan *DescribeAlertTypeResponse, <-chan error) {
	responseChan := make(chan *DescribeAlertTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAlertType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAlertTypeWithCallback invokes the cloud_siem.DescribeAlertType API asynchronously
func (client *Client) DescribeAlertTypeWithCallback(request *DescribeAlertTypeRequest, callback func(response *DescribeAlertTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAlertTypeResponse
		var err error
		defer close(result)
		response, err = client.DescribeAlertType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAlertTypeRequest is the request struct for api DescribeAlertType
type DescribeAlertTypeRequest struct {
	*requests.RpcRequest
}

// DescribeAlertTypeResponse is the response struct for api DescribeAlertType
type DescribeAlertTypeResponse struct {
	*responses.BaseResponse
	Success   bool       `json:"Success" xml:"Success"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeAlertTypeRequest creates a request to invoke DescribeAlertType API
func CreateDescribeAlertTypeRequest() (request *DescribeAlertTypeRequest) {
	request = &DescribeAlertTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeAlertType", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAlertTypeResponse creates a response to parse from DescribeAlertType response
func CreateDescribeAlertTypeResponse() (response *DescribeAlertTypeResponse) {
	response = &DescribeAlertTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
