package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDeviceRelation invokes the cdrs.ListDeviceRelation API synchronously
func (client *Client) ListDeviceRelation(request *ListDeviceRelationRequest) (response *ListDeviceRelationResponse, err error) {
	response = CreateListDeviceRelationResponse()
	err = client.DoAction(request, response)
	return
}

// ListDeviceRelationWithChan invokes the cdrs.ListDeviceRelation API asynchronously
func (client *Client) ListDeviceRelationWithChan(request *ListDeviceRelationRequest) (<-chan *ListDeviceRelationResponse, <-chan error) {
	responseChan := make(chan *ListDeviceRelationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDeviceRelation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDeviceRelationWithCallback invokes the cdrs.ListDeviceRelation API asynchronously
func (client *Client) ListDeviceRelationWithCallback(request *ListDeviceRelationRequest, callback func(response *ListDeviceRelationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDeviceRelationResponse
		var err error
		defer close(result)
		response, err = client.ListDeviceRelation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDeviceRelationRequest is the request struct for api ListDeviceRelation
type ListDeviceRelationRequest struct {
	*requests.RpcRequest
	DeviceId  string `position:"Body" name:"DeviceId"`
	AppName   string `position:"Body" name:"AppName"`
	NameSpace string `position:"Body" name:"NameSpace"`
}

// ListDeviceRelationResponse is the response struct for api ListDeviceRelation
type ListDeviceRelationResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Code      string     `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateListDeviceRelationRequest creates a request to invoke ListDeviceRelation API
func CreateListDeviceRelationRequest() (request *ListDeviceRelationRequest) {
	request = &ListDeviceRelationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "ListDeviceRelation", "", "")
	request.Method = requests.POST
	return
}

// CreateListDeviceRelationResponse creates a response to parse from ListDeviceRelation response
func CreateListDeviceRelationResponse() (response *ListDeviceRelationResponse) {
	response = &ListDeviceRelationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
