package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetCdnDomainSSLCertificate invokes the cdn.SetCdnDomainSSLCertificate API synchronously
func (client *Client) SetCdnDomainSSLCertificate(request *SetCdnDomainSSLCertificateRequest) (response *SetCdnDomainSSLCertificateResponse, err error) {
	response = CreateSetCdnDomainSSLCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// SetCdnDomainSSLCertificateWithChan invokes the cdn.SetCdnDomainSSLCertificate API asynchronously
func (client *Client) SetCdnDomainSSLCertificateWithChan(request *SetCdnDomainSSLCertificateRequest) (<-chan *SetCdnDomainSSLCertificateResponse, <-chan error) {
	responseChan := make(chan *SetCdnDomainSSLCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetCdnDomainSSLCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetCdnDomainSSLCertificateWithCallback invokes the cdn.SetCdnDomainSSLCertificate API asynchronously
func (client *Client) SetCdnDomainSSLCertificateWithCallback(request *SetCdnDomainSSLCertificateRequest, callback func(response *SetCdnDomainSSLCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetCdnDomainSSLCertificateResponse
		var err error
		defer close(result)
		response, err = client.SetCdnDomainSSLCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetCdnDomainSSLCertificateRequest is the request struct for api SetCdnDomainSSLCertificate
type SetCdnDomainSSLCertificateRequest struct {
	*requests.RpcRequest
	SSLProtocol   string           `position:"Query" name:"SSLProtocol"`
	CertId        requests.Integer `position:"Query" name:"CertId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	CertType      string           `position:"Query" name:"CertType"`
	SSLPri        string           `position:"Query" name:"SSLPri"`
	CertRegion    string           `position:"Query" name:"CertRegion"`
	CertName      string           `position:"Query" name:"CertName"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SSLPub        string           `position:"Query" name:"SSLPub"`
}

// SetCdnDomainSSLCertificateResponse is the response struct for api SetCdnDomainSSLCertificate
type SetCdnDomainSSLCertificateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetCdnDomainSSLCertificateRequest creates a request to invoke SetCdnDomainSSLCertificate API
func CreateSetCdnDomainSSLCertificateRequest() (request *SetCdnDomainSSLCertificateRequest) {
	request = &SetCdnDomainSSLCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "SetCdnDomainSSLCertificate", "", "")
	request.Method = requests.POST
	return
}

// CreateSetCdnDomainSSLCertificateResponse creates a response to parse from SetCdnDomainSSLCertificate response
func CreateSetCdnDomainSSLCertificateResponse() (response *SetCdnDomainSSLCertificateResponse) {
	response = &SetCdnDomainSSLCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
