package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCdnSubTask invokes the cdn.DeleteCdnSubTask API synchronously
func (client *Client) DeleteCdnSubTask(request *DeleteCdnSubTaskRequest) (response *DeleteCdnSubTaskResponse, err error) {
	response = CreateDeleteCdnSubTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCdnSubTaskWithChan invokes the cdn.DeleteCdnSubTask API asynchronously
func (client *Client) DeleteCdnSubTaskWithChan(request *DeleteCdnSubTaskRequest) (<-chan *DeleteCdnSubTaskResponse, <-chan error) {
	responseChan := make(chan *DeleteCdnSubTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCdnSubTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCdnSubTaskWithCallback invokes the cdn.DeleteCdnSubTask API asynchronously
func (client *Client) DeleteCdnSubTaskWithCallback(request *DeleteCdnSubTaskRequest, callback func(response *DeleteCdnSubTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCdnSubTaskResponse
		var err error
		defer close(result)
		response, err = client.DeleteCdnSubTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCdnSubTaskRequest is the request struct for api DeleteCdnSubTask
type DeleteCdnSubTaskRequest struct {
	*requests.RpcRequest
}

// DeleteCdnSubTaskResponse is the response struct for api DeleteCdnSubTask
type DeleteCdnSubTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteCdnSubTaskRequest creates a request to invoke DeleteCdnSubTask API
func CreateDeleteCdnSubTaskRequest() (request *DeleteCdnSubTaskRequest) {
	request = &DeleteCdnSubTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DeleteCdnSubTask", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteCdnSubTaskResponse creates a response to parse from DeleteCdnSubTask response
func CreateDeleteCdnSubTaskResponse() (response *DeleteCdnSubTaskResponse) {
	response = &DeleteCdnSubTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
