package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGroupAuthorizationRules invokes the cc5g.ListGroupAuthorizationRules API synchronously
func (client *Client) ListGroupAuthorizationRules(request *ListGroupAuthorizationRulesRequest) (response *ListGroupAuthorizationRulesResponse, err error) {
	response = CreateListGroupAuthorizationRulesResponse()
	err = client.DoAction(request, response)
	return
}

// ListGroupAuthorizationRulesWithChan invokes the cc5g.ListGroupAuthorizationRules API asynchronously
func (client *Client) ListGroupAuthorizationRulesWithChan(request *ListGroupAuthorizationRulesRequest) (<-chan *ListGroupAuthorizationRulesResponse, <-chan error) {
	responseChan := make(chan *ListGroupAuthorizationRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGroupAuthorizationRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGroupAuthorizationRulesWithCallback invokes the cc5g.ListGroupAuthorizationRules API asynchronously
func (client *Client) ListGroupAuthorizationRulesWithCallback(request *ListGroupAuthorizationRulesRequest, callback func(response *ListGroupAuthorizationRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGroupAuthorizationRulesResponse
		var err error
		defer close(result)
		response, err = client.ListGroupAuthorizationRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGroupAuthorizationRulesRequest is the request struct for api ListGroupAuthorizationRules
type ListGroupAuthorizationRulesRequest struct {
	*requests.RpcRequest
	WirelessCloudConnectorGroupId string           `position:"Query" name:"WirelessCloudConnectorGroupId"`
	DestinationType               string           `position:"Query" name:"DestinationType"`
	Destination                   string           `position:"Query" name:"Destination"`
	Type                          string           `position:"Query" name:"Type"`
	Protocol                      string           `position:"Query" name:"Protocol"`
	AuthorizationRuleIds          *[]string        `position:"Query" name:"AuthorizationRuleIds"  type:"Repeated"`
	NextToken                     string           `position:"Query" name:"NextToken"`
	Policy                        string           `position:"Query" name:"Policy"`
	Dns                           requests.Boolean `position:"Query" name:"Dns"`
	DestinationPort               string           `position:"Query" name:"DestinationPort"`
	Names                         *[]string        `position:"Query" name:"Names"  type:"Repeated"`
	MaxResults                    requests.Integer `position:"Query" name:"MaxResults"`
	Statuses                      *[]string        `position:"Query" name:"Statuses"  type:"Repeated"`
}

// ListGroupAuthorizationRulesResponse is the response struct for api ListGroupAuthorizationRules
type ListGroupAuthorizationRulesResponse struct {
	*responses.BaseResponse
	RequestId               string                   `json:"RequestId" xml:"RequestId"`
	NextToken               string                   `json:"NextToken" xml:"NextToken"`
	MaxResults              string                   `json:"MaxResults" xml:"MaxResults"`
	TotalCount              string                   `json:"TotalCount" xml:"TotalCount"`
	GroupAuthorizationRules []GroupAuthorizationRule `json:"GroupAuthorizationRules" xml:"GroupAuthorizationRules"`
}

// CreateListGroupAuthorizationRulesRequest creates a request to invoke ListGroupAuthorizationRules API
func CreateListGroupAuthorizationRulesRequest() (request *ListGroupAuthorizationRulesRequest) {
	request = &ListGroupAuthorizationRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "ListGroupAuthorizationRules", "fivegcc", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListGroupAuthorizationRulesResponse creates a response to parse from ListGroupAuthorizationRules response
func CreateListGroupAuthorizationRulesResponse() (response *ListGroupAuthorizationRulesResponse) {
	response = &ListGroupAuthorizationRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
