package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTransitRouterMulticastDomains invokes the cbn.ListTransitRouterMulticastDomains API synchronously
func (client *Client) ListTransitRouterMulticastDomains(request *ListTransitRouterMulticastDomainsRequest) (response *ListTransitRouterMulticastDomainsResponse, err error) {
	response = CreateListTransitRouterMulticastDomainsResponse()
	err = client.DoAction(request, response)
	return
}

// ListTransitRouterMulticastDomainsWithChan invokes the cbn.ListTransitRouterMulticastDomains API asynchronously
func (client *Client) ListTransitRouterMulticastDomainsWithChan(request *ListTransitRouterMulticastDomainsRequest) (<-chan *ListTransitRouterMulticastDomainsResponse, <-chan error) {
	responseChan := make(chan *ListTransitRouterMulticastDomainsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTransitRouterMulticastDomains(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTransitRouterMulticastDomainsWithCallback invokes the cbn.ListTransitRouterMulticastDomains API asynchronously
func (client *Client) ListTransitRouterMulticastDomainsWithCallback(request *ListTransitRouterMulticastDomainsRequest, callback func(response *ListTransitRouterMulticastDomainsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTransitRouterMulticastDomainsResponse
		var err error
		defer close(result)
		response, err = client.ListTransitRouterMulticastDomains(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTransitRouterMulticastDomainsRequest is the request struct for api ListTransitRouterMulticastDomains
type ListTransitRouterMulticastDomainsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                requests.Integer                        `position:"Query" name:"ResourceOwnerId"`
	ClientToken                    string                                  `position:"Query" name:"ClientToken"`
	CenId                          string                                  `position:"Query" name:"CenId"`
	TransitRouterMulticastDomainId string                                  `position:"Query" name:"TransitRouterMulticastDomainId"`
	NextToken                      string                                  `position:"Query" name:"NextToken"`
	Tag                            *[]ListTransitRouterMulticastDomainsTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceOwnerAccount           string                                  `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                   string                                  `position:"Query" name:"OwnerAccount"`
	OwnerId                        requests.Integer                        `position:"Query" name:"OwnerId"`
	TransitRouterId                string                                  `position:"Query" name:"TransitRouterId"`
	Version                        string                                  `position:"Query" name:"Version"`
	MaxResults                     requests.Integer                        `position:"Query" name:"MaxResults"`
}

// ListTransitRouterMulticastDomainsTag is a repeated param struct in ListTransitRouterMulticastDomainsRequest
type ListTransitRouterMulticastDomainsTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// ListTransitRouterMulticastDomainsResponse is the response struct for api ListTransitRouterMulticastDomains
type ListTransitRouterMulticastDomainsResponse struct {
	*responses.BaseResponse
	RequestId                     string                         `json:"RequestId" xml:"RequestId"`
	TotalCount                    int                            `json:"TotalCount" xml:"TotalCount"`
	MaxResults                    int                            `json:"MaxResults" xml:"MaxResults"`
	NextToken                     string                         `json:"NextToken" xml:"NextToken"`
	TransitRouterMulticastDomains []TransitRouterMulticastDomain `json:"TransitRouterMulticastDomains" xml:"TransitRouterMulticastDomains"`
}

// CreateListTransitRouterMulticastDomainsRequest creates a request to invoke ListTransitRouterMulticastDomains API
func CreateListTransitRouterMulticastDomainsRequest() (request *ListTransitRouterMulticastDomainsRequest) {
	request = &ListTransitRouterMulticastDomainsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "ListTransitRouterMulticastDomains", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListTransitRouterMulticastDomainsResponse creates a response to parse from ListTransitRouterMulticastDomains response
func CreateListTransitRouterMulticastDomainsResponse() (response *ListTransitRouterMulticastDomainsResponse) {
	response = &ListTransitRouterMulticastDomainsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
