package cassandra

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCluster invokes the cassandra.ModifyCluster API synchronously
func (client *Client) ModifyCluster(request *ModifyClusterRequest) (response *ModifyClusterResponse, err error) {
	response = CreateModifyClusterResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyClusterWithChan invokes the cassandra.ModifyCluster API asynchronously
func (client *Client) ModifyClusterWithChan(request *ModifyClusterRequest) (<-chan *ModifyClusterResponse, <-chan error) {
	responseChan := make(chan *ModifyClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyClusterWithCallback invokes the cassandra.ModifyCluster API asynchronously
func (client *Client) ModifyClusterWithCallback(request *ModifyClusterRequest, callback func(response *ModifyClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyClusterResponse
		var err error
		defer close(result)
		response, err = client.ModifyCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyClusterRequest is the request struct for api ModifyCluster
type ModifyClusterRequest struct {
	*requests.RpcRequest
	ClusterName string `position:"Query" name:"ClusterName"`
	ClusterId   string `position:"Query" name:"ClusterId"`
}

// ModifyClusterResponse is the response struct for api ModifyCluster
type ModifyClusterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyClusterRequest creates a request to invoke ModifyCluster API
func CreateModifyClusterRequest() (request *ModifyClusterRequest) {
	request = &ModifyClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cassandra", "2019-01-01", "ModifyCluster", "Cassandra", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyClusterResponse creates a response to parse from ModifyCluster response
func CreateModifyClusterResponse() (response *ModifyClusterResponse) {
	response = &ModifyClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
