package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Verify invokes the cas.Verify API synchronously
func (client *Client) Verify(request *VerifyRequest) (response *VerifyResponse, err error) {
	response = CreateVerifyResponse()
	err = client.DoAction(request, response)
	return
}

// VerifyWithChan invokes the cas.Verify API asynchronously
func (client *Client) VerifyWithChan(request *VerifyRequest) (<-chan *VerifyResponse, <-chan error) {
	responseChan := make(chan *VerifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Verify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifyWithCallback invokes the cas.Verify API asynchronously
func (client *Client) VerifyWithCallback(request *VerifyRequest, callback func(response *VerifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifyResponse
		var err error
		defer close(result)
		response, err = client.Verify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifyRequest is the request struct for api Verify
type VerifyRequest struct {
	*requests.RpcRequest
	MessageType      string `position:"Query" name:"MessageType"`
	SigningAlgorithm string `position:"Query" name:"SigningAlgorithm"`
	Message          string `position:"Query" name:"Message"`
	SignatureValue   string `position:"Query" name:"SignatureValue"`
	SourceIp         string `position:"Query" name:"SourceIp"`
	CertIdentifier   string `position:"Query" name:"CertIdentifier"`
}

// VerifyResponse is the response struct for api Verify
type VerifyResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	SignatureValid bool   `json:"SignatureValid" xml:"SignatureValid"`
}

// CreateVerifyRequest creates a request to invoke Verify API
func CreateVerifyRequest() (request *VerifyRequest) {
	request = &VerifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-04-07", "Verify", "cas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateVerifyResponse creates a response to parse from Verify response
func CreateVerifyResponse() (response *VerifyResponse) {
	response = &VerifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
