package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceAmortizedCostByConsumePeriod invokes the bssopenapi.DescribeInstanceAmortizedCostByConsumePeriod API synchronously
func (client *Client) DescribeInstanceAmortizedCostByConsumePeriod(request *DescribeInstanceAmortizedCostByConsumePeriodRequest) (response *DescribeInstanceAmortizedCostByConsumePeriodResponse, err error) {
	response = CreateDescribeInstanceAmortizedCostByConsumePeriodResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceAmortizedCostByConsumePeriodWithChan invokes the bssopenapi.DescribeInstanceAmortizedCostByConsumePeriod API asynchronously
func (client *Client) DescribeInstanceAmortizedCostByConsumePeriodWithChan(request *DescribeInstanceAmortizedCostByConsumePeriodRequest) (<-chan *DescribeInstanceAmortizedCostByConsumePeriodResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceAmortizedCostByConsumePeriodResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceAmortizedCostByConsumePeriod(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceAmortizedCostByConsumePeriodWithCallback invokes the bssopenapi.DescribeInstanceAmortizedCostByConsumePeriod API asynchronously
func (client *Client) DescribeInstanceAmortizedCostByConsumePeriodWithCallback(request *DescribeInstanceAmortizedCostByConsumePeriodRequest, callback func(response *DescribeInstanceAmortizedCostByConsumePeriodResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceAmortizedCostByConsumePeriodResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceAmortizedCostByConsumePeriod(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceAmortizedCostByConsumePeriodRequest is the request struct for api DescribeInstanceAmortizedCostByConsumePeriod
type DescribeInstanceAmortizedCostByConsumePeriodRequest struct {
	*requests.RpcRequest
	ProductDetail            string           `position:"Body" name:"ProductDetail"`
	ProductCode              string           `position:"Body" name:"ProductCode"`
	BillOwnerIdList          *[]string        `position:"Body" name:"BillOwnerIdList"  type:"Repeated"`
	SubscriptionType         string           `position:"Body" name:"SubscriptionType"`
	BillingCycle             string           `position:"Body" name:"BillingCycle"`
	CostUnitCode             string           `position:"Body" name:"CostUnitCode"`
	AmortizationPeriodFilter *[]string        `position:"Body" name:"AmortizationPeriodFilter"  type:"Repeated"`
	NextToken                string           `position:"Body" name:"NextToken"`
	BillUserIdList           *[]string        `position:"Body" name:"BillUserIdList"  type:"Repeated"`
	InstanceIdList           *[]string        `position:"Body" name:"InstanceIdList"  type:"Repeated"`
	MaxResults               requests.Integer `position:"Body" name:"MaxResults"`
}

// DescribeInstanceAmortizedCostByConsumePeriodResponse is the response struct for api DescribeInstanceAmortizedCostByConsumePeriod
type DescribeInstanceAmortizedCostByConsumePeriodResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeInstanceAmortizedCostByConsumePeriodRequest creates a request to invoke DescribeInstanceAmortizedCostByConsumePeriod API
func CreateDescribeInstanceAmortizedCostByConsumePeriodRequest() (request *DescribeInstanceAmortizedCostByConsumePeriodRequest) {
	request = &DescribeInstanceAmortizedCostByConsumePeriodRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "DescribeInstanceAmortizedCostByConsumePeriod", "bssopenapi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceAmortizedCostByConsumePeriodResponse creates a response to parse from DescribeInstanceAmortizedCostByConsumePeriod response
func CreateDescribeInstanceAmortizedCostByConsumePeriodResponse() (response *DescribeInstanceAmortizedCostByConsumePeriodResponse) {
	response = &DescribeInstanceAmortizedCostByConsumePeriodResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
