package avatar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendVaml invokes the avatar.SendVaml API synchronously
func (client *Client) SendVaml(request *SendVamlRequest) (response *SendVamlResponse, err error) {
	response = CreateSendVamlResponse()
	err = client.DoAction(request, response)
	return
}

// SendVamlWithChan invokes the avatar.SendVaml API asynchronously
func (client *Client) SendVamlWithChan(request *SendVamlRequest) (<-chan *SendVamlResponse, <-chan error) {
	responseChan := make(chan *SendVamlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendVaml(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendVamlWithCallback invokes the avatar.SendVaml API asynchronously
func (client *Client) SendVamlWithCallback(request *SendVamlRequest, callback func(response *SendVamlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendVamlResponse
		var err error
		defer close(result)
		response, err = client.SendVaml(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendVamlRequest is the request struct for api SendVaml
type SendVamlRequest struct {
	*requests.RpcRequest
	TenantId  requests.Integer `position:"Query" name:"TenantId"`
	SessionId string           `position:"Query" name:"SessionId"`
	Vaml      string           `position:"Query" name:"Vaml"`
}

// SendVamlResponse is the response struct for api SendVaml
type SendVamlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSendVamlRequest creates a request to invoke SendVaml API
func CreateSendVamlRequest() (request *SendVamlRequest) {
	request = &SendVamlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("avatar", "2022-01-30", "SendVaml", "", "")
	request.Method = requests.POST
	return
}

// CreateSendVamlResponse creates a response to parse from SendVaml response
func CreateSendVamlResponse() (response *SendVamlResponse) {
	response = &SendVamlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
