package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEscalationPolicies invokes the arms.ListEscalationPolicies API synchronously
func (client *Client) ListEscalationPolicies(request *ListEscalationPoliciesRequest) (response *ListEscalationPoliciesResponse, err error) {
	response = CreateListEscalationPoliciesResponse()
	err = client.DoAction(request, response)
	return
}

// ListEscalationPoliciesWithChan invokes the arms.ListEscalationPolicies API asynchronously
func (client *Client) ListEscalationPoliciesWithChan(request *ListEscalationPoliciesRequest) (<-chan *ListEscalationPoliciesResponse, <-chan error) {
	responseChan := make(chan *ListEscalationPoliciesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEscalationPolicies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEscalationPoliciesWithCallback invokes the arms.ListEscalationPolicies API asynchronously
func (client *Client) ListEscalationPoliciesWithCallback(request *ListEscalationPoliciesRequest, callback func(response *ListEscalationPoliciesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEscalationPoliciesResponse
		var err error
		defer close(result)
		response, err = client.ListEscalationPolicies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEscalationPoliciesRequest is the request struct for api ListEscalationPolicies
type ListEscalationPoliciesRequest struct {
	*requests.RpcRequest
	Size requests.Integer `position:"Query" name:"Size"`
	Name string           `position:"Query" name:"Name"`
	Page requests.Integer `position:"Query" name:"Page"`
}

// ListEscalationPoliciesResponse is the response struct for api ListEscalationPolicies
type ListEscalationPoliciesResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	PageBean  PageBean `json:"PageBean" xml:"PageBean"`
}

// CreateListEscalationPoliciesRequest creates a request to invoke ListEscalationPolicies API
func CreateListEscalationPoliciesRequest() (request *ListEscalationPoliciesRequest) {
	request = &ListEscalationPoliciesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "ListEscalationPolicies", "arms", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListEscalationPoliciesResponse creates a response to parse from ListEscalationPolicies response
func CreateListEscalationPoliciesResponse() (response *ListEscalationPoliciesResponse) {
	response = &ListEscalationPoliciesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
