package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWeChEntertainment invokes the alinlp.GetWeChEntertainment API synchronously
func (client *Client) GetWeChEntertainment(request *GetWeChEntertainmentRequest) (response *GetWeChEntertainmentResponse, err error) {
	response = CreateGetWeChEntertainmentResponse()
	err = client.DoAction(request, response)
	return
}

// GetWeChEntertainmentWithChan invokes the alinlp.GetWeChEntertainment API asynchronously
func (client *Client) GetWeChEntertainmentWithChan(request *GetWeChEntertainmentRequest) (<-chan *GetWeChEntertainmentResponse, <-chan error) {
	responseChan := make(chan *GetWeChEntertainmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWeChEntertainment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWeChEntertainmentWithCallback invokes the alinlp.GetWeChEntertainment API asynchronously
func (client *Client) GetWeChEntertainmentWithCallback(request *GetWeChEntertainmentRequest, callback func(response *GetWeChEntertainmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWeChEntertainmentResponse
		var err error
		defer close(result)
		response, err = client.GetWeChEntertainment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWeChEntertainmentRequest is the request struct for api GetWeChEntertainment
type GetWeChEntertainmentRequest struct {
	*requests.RpcRequest
	Type        string `position:"Body" name:"Type"`
	ServiceCode string `position:"Body" name:"ServiceCode"`
	Size        string `position:"Body" name:"Size"`
	TokenizerId string `position:"Body" name:"TokenizerId"`
	Text        string `position:"Body" name:"Text"`
	Operation   string `position:"Body" name:"Operation"`
}

// GetWeChEntertainmentResponse is the response struct for api GetWeChEntertainment
type GetWeChEntertainmentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetWeChEntertainmentRequest creates a request to invoke GetWeChEntertainment API
func CreateGetWeChEntertainmentRequest() (request *GetWeChEntertainmentRequest) {
	request = &GetWeChEntertainmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetWeChEntertainment", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetWeChEntertainmentResponse creates a response to parse from GetWeChEntertainment response
func CreateGetWeChEntertainmentResponse() (response *GetWeChEntertainmentResponse) {
	response = &GetWeChEntertainmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
