package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSystemRules invokes the ahas_openapi.ListSystemRules API synchronously
func (client *Client) ListSystemRules(request *ListSystemRulesRequest) (response *ListSystemRulesResponse, err error) {
	response = CreateListSystemRulesResponse()
	err = client.DoAction(request, response)
	return
}

// ListSystemRulesWithChan invokes the ahas_openapi.ListSystemRules API asynchronously
func (client *Client) ListSystemRulesWithChan(request *ListSystemRulesRequest) (<-chan *ListSystemRulesResponse, <-chan error) {
	responseChan := make(chan *ListSystemRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSystemRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSystemRulesWithCallback invokes the ahas_openapi.ListSystemRules API asynchronously
func (client *Client) ListSystemRulesWithCallback(request *ListSystemRulesRequest, callback func(response *ListSystemRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSystemRulesResponse
		var err error
		defer close(result)
		response, err = client.ListSystemRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSystemRulesRequest is the request struct for api ListSystemRules
type ListSystemRulesRequest struct {
	*requests.RpcRequest
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	AppName      string           `position:"Query" name:"AppName"`
	Namespace    string           `position:"Query" name:"Namespace"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	PageIndex    requests.Integer `position:"Query" name:"PageIndex"`
}

// ListSystemRulesResponse is the response struct for api ListSystemRules
type ListSystemRulesResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListSystemRulesRequest creates a request to invoke ListSystemRules API
func CreateListSystemRulesRequest() (request *ListSystemRulesRequest) {
	request = &ListSystemRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "ListSystemRules", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSystemRulesResponse creates a response to parse from ListSystemRules response
func CreateListSystemRulesResponse() (response *ListSystemRulesResponse) {
	response = &ListSystemRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
