package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableHotParamRule invokes the ahas_openapi.DisableHotParamRule API synchronously
func (client *Client) DisableHotParamRule(request *DisableHotParamRuleRequest) (response *DisableHotParamRuleResponse, err error) {
	response = CreateDisableHotParamRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DisableHotParamRuleWithChan invokes the ahas_openapi.DisableHotParamRule API asynchronously
func (client *Client) DisableHotParamRuleWithChan(request *DisableHotParamRuleRequest) (<-chan *DisableHotParamRuleResponse, <-chan error) {
	responseChan := make(chan *DisableHotParamRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableHotParamRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableHotParamRuleWithCallback invokes the ahas_openapi.DisableHotParamRule API asynchronously
func (client *Client) DisableHotParamRuleWithCallback(request *DisableHotParamRuleRequest, callback func(response *DisableHotParamRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableHotParamRuleResponse
		var err error
		defer close(result)
		response, err = client.DisableHotParamRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableHotParamRuleRequest is the request struct for api DisableHotParamRule
type DisableHotParamRuleRequest struct {
	*requests.RpcRequest
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	RuleId       requests.Integer `position:"Query" name:"RuleId"`
}

// DisableHotParamRuleResponse is the response struct for api DisableHotParamRule
type DisableHotParamRuleResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDisableHotParamRuleRequest creates a request to invoke DisableHotParamRule API
func CreateDisableHotParamRuleRequest() (request *DisableHotParamRuleRequest) {
	request = &DisableHotParamRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "DisableHotParamRule", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableHotParamRuleResponse creates a response to parse from DisableHotParamRule response
func CreateDisableHotParamRuleResponse() (response *DisableHotParamRuleResponse) {
	response = &DisableHotParamRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
