package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyWebLockOperateEvents invokes the aegis.ModifyWebLockOperateEvents API synchronously
// api document: https://help.aliyun.com/api/aegis/modifyweblockoperateevents.html
func (client *Client) ModifyWebLockOperateEvents(request *ModifyWebLockOperateEventsRequest) (response *ModifyWebLockOperateEventsResponse, err error) {
	response = CreateModifyWebLockOperateEventsResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyWebLockOperateEventsWithChan invokes the aegis.ModifyWebLockOperateEvents API asynchronously
// api document: https://help.aliyun.com/api/aegis/modifyweblockoperateevents.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyWebLockOperateEventsWithChan(request *ModifyWebLockOperateEventsRequest) (<-chan *ModifyWebLockOperateEventsResponse, <-chan error) {
	responseChan := make(chan *ModifyWebLockOperateEventsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyWebLockOperateEvents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyWebLockOperateEventsWithCallback invokes the aegis.ModifyWebLockOperateEvents API asynchronously
// api document: https://help.aliyun.com/api/aegis/modifyweblockoperateevents.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyWebLockOperateEventsWithCallback(request *ModifyWebLockOperateEventsRequest, callback func(response *ModifyWebLockOperateEventsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyWebLockOperateEventsResponse
		var err error
		defer close(result)
		response, err = client.ModifyWebLockOperateEvents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyWebLockOperateEventsRequest is the request struct for api ModifyWebLockOperateEvents
type ModifyWebLockOperateEventsRequest struct {
	*requests.RpcRequest
	SourceIp  string `position:"Query" name:"SourceIp"`
	Operation string `position:"Query" name:"Operation"`
	EventIds  string `position:"Query" name:"EventIds"`
}

// ModifyWebLockOperateEventsResponse is the response struct for api ModifyWebLockOperateEvents
type ModifyWebLockOperateEventsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyWebLockOperateEventsRequest creates a request to invoke ModifyWebLockOperateEvents API
func CreateModifyWebLockOperateEventsRequest() (request *ModifyWebLockOperateEventsRequest) {
	request = &ModifyWebLockOperateEventsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "ModifyWebLockOperateEvents", "vipaegis", "openAPI")
	return
}

// CreateModifyWebLockOperateEventsResponse creates a response to parse from ModifyWebLockOperateEvents response
func CreateModifyWebLockOperateEventsResponse() (response *ModifyWebLockOperateEventsResponse) {
	response = &ModifyWebLockOperateEventsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
