package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVulMachineList invokes the aegis.DescribeVulMachineList API synchronously
// api document: https://help.aliyun.com/api/aegis/describevulmachinelist.html
func (client *Client) DescribeVulMachineList(request *DescribeVulMachineListRequest) (response *DescribeVulMachineListResponse, err error) {
	response = CreateDescribeVulMachineListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVulMachineListWithChan invokes the aegis.DescribeVulMachineList API asynchronously
// api document: https://help.aliyun.com/api/aegis/describevulmachinelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVulMachineListWithChan(request *DescribeVulMachineListRequest) (<-chan *DescribeVulMachineListResponse, <-chan error) {
	responseChan := make(chan *DescribeVulMachineListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVulMachineList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVulMachineListWithCallback invokes the aegis.DescribeVulMachineList API asynchronously
// api document: https://help.aliyun.com/api/aegis/describevulmachinelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVulMachineListWithCallback(request *DescribeVulMachineListRequest, callback func(response *DescribeVulMachineListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVulMachineListResponse
		var err error
		defer close(result)
		response, err = client.DescribeVulMachineList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVulMachineListRequest is the request struct for api DescribeVulMachineList
type DescribeVulMachineListRequest struct {
	*requests.RpcRequest
	SourceIp string           `position:"Query" name:"SourceIp"`
	EndTs    requests.Integer `position:"Query" name:"EndTs"`
	StartTs  requests.Integer `position:"Query" name:"StartTs"`
	Uuids    string           `position:"Query" name:"Uuids"`
}

// DescribeVulMachineListResponse is the response struct for api DescribeVulMachineList
type DescribeVulMachineListResponse struct {
	*responses.BaseResponse
	RequestId         string             `json:"RequestId" xml:"RequestId"`
	TotalCount        int                `json:"TotalCount" xml:"TotalCount"`
	MachineStatistics []MachineStatistic `json:"MachineStatistics" xml:"MachineStatistics"`
}

// CreateDescribeVulMachineListRequest creates a request to invoke DescribeVulMachineList API
func CreateDescribeVulMachineListRequest() (request *DescribeVulMachineListRequest) {
	request = &DescribeVulMachineListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeVulMachineList", "vipaegis", "openAPI")
	return
}

// CreateDescribeVulMachineListResponse creates a response to parse from DescribeVulMachineList response
func CreateDescribeVulMachineListResponse() (response *DescribeVulMachineListResponse) {
	response = &DescribeVulMachineListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
