package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserSetting invokes the aegis.DescribeUserSetting API synchronously
// api document: https://help.aliyun.com/api/aegis/describeusersetting.html
func (client *Client) DescribeUserSetting(request *DescribeUserSettingRequest) (response *DescribeUserSettingResponse, err error) {
	response = CreateDescribeUserSettingResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserSettingWithChan invokes the aegis.DescribeUserSetting API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeusersetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUserSettingWithChan(request *DescribeUserSettingRequest) (<-chan *DescribeUserSettingResponse, <-chan error) {
	responseChan := make(chan *DescribeUserSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserSettingWithCallback invokes the aegis.DescribeUserSetting API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeusersetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUserSettingWithCallback(request *DescribeUserSettingRequest, callback func(response *DescribeUserSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserSettingResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserSettingRequest is the request struct for api DescribeUserSetting
type DescribeUserSettingRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeUserSettingResponse is the response struct for api DescribeUserSetting
type DescribeUserSettingResponse struct {
	*responses.BaseResponse
	RequestId              string `json:"RequestId" xml:"RequestId"`
	InvalidWarningKeepDays int    `json:"InvalidWarningKeepDays" xml:"InvalidWarningKeepDays"`
	AlertLevels            string `json:"AlertLevels" xml:"AlertLevels"`
}

// CreateDescribeUserSettingRequest creates a request to invoke DescribeUserSetting API
func CreateDescribeUserSettingRequest() (request *DescribeUserSettingRequest) {
	request = &DescribeUserSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeUserSetting", "vipaegis", "openAPI")
	return
}

// CreateDescribeUserSettingResponse creates a response to parse from DescribeUserSetting response
func CreateDescribeUserSettingResponse() (response *DescribeUserSettingResponse) {
	response = &DescribeUserSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
