package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCanTrySas invokes the aegis.DescribeCanTrySas API synchronously
// api document: https://help.aliyun.com/api/aegis/describecantrysas.html
func (client *Client) DescribeCanTrySas(request *DescribeCanTrySasRequest) (response *DescribeCanTrySasResponse, err error) {
	response = CreateDescribeCanTrySasResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCanTrySasWithChan invokes the aegis.DescribeCanTrySas API asynchronously
// api document: https://help.aliyun.com/api/aegis/describecantrysas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCanTrySasWithChan(request *DescribeCanTrySasRequest) (<-chan *DescribeCanTrySasResponse, <-chan error) {
	responseChan := make(chan *DescribeCanTrySasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCanTrySas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCanTrySasWithCallback invokes the aegis.DescribeCanTrySas API asynchronously
// api document: https://help.aliyun.com/api/aegis/describecantrysas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCanTrySasWithCallback(request *DescribeCanTrySasRequest, callback func(response *DescribeCanTrySasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCanTrySasResponse
		var err error
		defer close(result)
		response, err = client.DescribeCanTrySas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCanTrySasRequest is the request struct for api DescribeCanTrySas
type DescribeCanTrySasRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeCanTrySasResponse is the response struct for api DescribeCanTrySas
type DescribeCanTrySasResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	CanTry    int    `json:"CanTry" xml:"CanTry"`
}

// CreateDescribeCanTrySasRequest creates a request to invoke DescribeCanTrySas API
func CreateDescribeCanTrySasRequest() (request *DescribeCanTrySasRequest) {
	request = &DescribeCanTrySasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeCanTrySas", "vipaegis", "openAPI")
	return
}

// CreateDescribeCanTrySasResponse creates a response to parse from DescribeCanTrySas response
func CreateDescribeCanTrySasResponse() (response *DescribeCanTrySasResponse) {
	response = &DescribeCanTrySasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
