package address_purification

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInputSearch invokes the address_purification.GetInputSearch API synchronously
func (client *Client) GetInputSearch(request *GetInputSearchRequest) (response *GetInputSearchResponse, err error) {
	response = CreateGetInputSearchResponse()
	err = client.DoAction(request, response)
	return
}

// GetInputSearchWithChan invokes the address_purification.GetInputSearch API asynchronously
func (client *Client) GetInputSearchWithChan(request *GetInputSearchRequest) (<-chan *GetInputSearchResponse, <-chan error) {
	responseChan := make(chan *GetInputSearchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInputSearch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInputSearchWithCallback invokes the address_purification.GetInputSearch API asynchronously
func (client *Client) GetInputSearchWithCallback(request *GetInputSearchRequest, callback func(response *GetInputSearchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInputSearchResponse
		var err error
		defer close(result)
		response, err = client.GetInputSearch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInputSearchRequest is the request struct for api GetInputSearch
type GetInputSearchRequest struct {
	*requests.RpcRequest
	DefaultProvince string `position:"Body" name:"DefaultProvince"`
	ServiceCode     string `position:"Body" name:"ServiceCode"`
	DefaultCity     string `position:"Body" name:"DefaultCity"`
	DefaultDistrict string `position:"Body" name:"DefaultDistrict"`
	AppKey          string `position:"Body" name:"AppKey"`
	Text            string `position:"Body" name:"Text"`
}

// GetInputSearchResponse is the response struct for api GetInputSearch
type GetInputSearchResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetInputSearchRequest creates a request to invoke GetInputSearch API
func CreateGetInputSearchRequest() (request *GetInputSearchRequest) {
	request = &GetInputSearchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("address-purification", "2019-11-18", "GetInputSearch", "addrp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetInputSearchResponse creates a response to parse from GetInputSearch response
func CreateGetInputSearchResponse() (response *GetInputSearchResponse) {
	response = &GetInputSearchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
