package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiagnosisMonitorPerformance invokes the adb.DescribeDiagnosisMonitorPerformance API synchronously
func (client *Client) DescribeDiagnosisMonitorPerformance(request *DescribeDiagnosisMonitorPerformanceRequest) (response *DescribeDiagnosisMonitorPerformanceResponse, err error) {
	response = CreateDescribeDiagnosisMonitorPerformanceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiagnosisMonitorPerformanceWithChan invokes the adb.DescribeDiagnosisMonitorPerformance API asynchronously
func (client *Client) DescribeDiagnosisMonitorPerformanceWithChan(request *DescribeDiagnosisMonitorPerformanceRequest) (<-chan *DescribeDiagnosisMonitorPerformanceResponse, <-chan error) {
	responseChan := make(chan *DescribeDiagnosisMonitorPerformanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiagnosisMonitorPerformance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiagnosisMonitorPerformanceWithCallback invokes the adb.DescribeDiagnosisMonitorPerformance API asynchronously
func (client *Client) DescribeDiagnosisMonitorPerformanceWithCallback(request *DescribeDiagnosisMonitorPerformanceRequest, callback func(response *DescribeDiagnosisMonitorPerformanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiagnosisMonitorPerformanceResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiagnosisMonitorPerformance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiagnosisMonitorPerformanceRequest is the request struct for api DescribeDiagnosisMonitorPerformance
type DescribeDiagnosisMonitorPerformanceRequest struct {
	*requests.RpcRequest
	DBClusterId    string `position:"Query" name:"DBClusterId"`
	QueryCondition string `position:"Query" name:"QueryCondition"`
	EndTime        string `position:"Query" name:"EndTime"`
	StartTime      string `position:"Query" name:"StartTime"`
	Lang           string `position:"Query" name:"Lang"`
}

// DescribeDiagnosisMonitorPerformanceResponse is the response struct for api DescribeDiagnosisMonitorPerformance
type DescribeDiagnosisMonitorPerformanceResponse struct {
	*responses.BaseResponse
	PerformancesThreshold int     `json:"PerformancesThreshold" xml:"PerformancesThreshold"`
	PerformancesTruncated bool    `json:"PerformancesTruncated" xml:"PerformancesTruncated"`
	RequestId             string  `json:"RequestId" xml:"RequestId"`
	Performances          []Items `json:"Performances" xml:"Performances"`
}

// CreateDescribeDiagnosisMonitorPerformanceRequest creates a request to invoke DescribeDiagnosisMonitorPerformance API
func CreateDescribeDiagnosisMonitorPerformanceRequest() (request *DescribeDiagnosisMonitorPerformanceRequest) {
	request = &DescribeDiagnosisMonitorPerformanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeDiagnosisMonitorPerformance", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDiagnosisMonitorPerformanceResponse creates a response to parse from DescribeDiagnosisMonitorPerformance response
func CreateDescribeDiagnosisMonitorPerformanceResponse() (response *DescribeDiagnosisMonitorPerformanceResponse) {
	response = &DescribeDiagnosisMonitorPerformanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
