package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDirectory invokes the vs.DeleteDirectory API synchronously
func (client *Client) DeleteDirectory(request *DeleteDirectoryRequest) (response *DeleteDirectoryResponse, err error) {
	response = CreateDeleteDirectoryResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDirectoryWithChan invokes the vs.DeleteDirectory API asynchronously
func (client *Client) DeleteDirectoryWithChan(request *DeleteDirectoryRequest) (<-chan *DeleteDirectoryResponse, <-chan error) {
	responseChan := make(chan *DeleteDirectoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDirectory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDirectoryWithCallback invokes the vs.DeleteDirectory API asynchronously
func (client *Client) DeleteDirectoryWithCallback(request *DeleteDirectoryRequest, callback func(response *DeleteDirectoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDirectoryResponse
		var err error
		defer close(result)
		response, err = client.DeleteDirectory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDirectoryRequest is the request struct for api DeleteDirectory
type DeleteDirectoryRequest struct {
	*requests.RpcRequest
	Id      string           `position:"Query" name:"Id"`
	ShowLog string           `position:"Query" name:"ShowLog"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteDirectoryResponse is the response struct for api DeleteDirectory
type DeleteDirectoryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDirectoryRequest creates a request to invoke DeleteDirectory API
func CreateDeleteDirectoryRequest() (request *DeleteDirectoryRequest) {
	request = &DeleteDirectoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DeleteDirectory", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDirectoryResponse creates a response to parse from DeleteDirectory response
func CreateDeleteDirectoryResponse() (response *DeleteDirectoryResponse) {
	response = &DeleteDirectoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
