package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeExpressConnectTrafficQos invokes the vpc.DescribeExpressConnectTrafficQos API synchronously
func (client *Client) DescribeExpressConnectTrafficQos(request *DescribeExpressConnectTrafficQosRequest) (response *DescribeExpressConnectTrafficQosResponse, err error) {
	response = CreateDescribeExpressConnectTrafficQosResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeExpressConnectTrafficQosWithChan invokes the vpc.DescribeExpressConnectTrafficQos API asynchronously
func (client *Client) DescribeExpressConnectTrafficQosWithChan(request *DescribeExpressConnectTrafficQosRequest) (<-chan *DescribeExpressConnectTrafficQosResponse, <-chan error) {
	responseChan := make(chan *DescribeExpressConnectTrafficQosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeExpressConnectTrafficQos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeExpressConnectTrafficQosWithCallback invokes the vpc.DescribeExpressConnectTrafficQos API asynchronously
func (client *Client) DescribeExpressConnectTrafficQosWithCallback(request *DescribeExpressConnectTrafficQosRequest, callback func(response *DescribeExpressConnectTrafficQosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeExpressConnectTrafficQosResponse
		var err error
		defer close(result)
		response, err = client.DescribeExpressConnectTrafficQos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeExpressConnectTrafficQosRequest is the request struct for api DescribeExpressConnectTrafficQos
type DescribeExpressConnectTrafficQosRequest struct {
	*requests.RpcRequest
	ClientToken          string           `position:"Query" name:"ClientToken"`
	NextToken            string           `position:"Query" name:"NextToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	QosIdList            *[]string        `position:"Query" name:"QosIdList"  type:"Repeated"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	QosNameList          *[]string        `position:"Query" name:"QosNameList"  type:"Repeated"`
	MaxResults           requests.Integer `position:"Query" name:"MaxResults"`
}

// DescribeExpressConnectTrafficQosResponse is the response struct for api DescribeExpressConnectTrafficQos
type DescribeExpressConnectTrafficQosResponse struct {
	*responses.BaseResponse
	RequestId  string        `json:"RequestId" xml:"RequestId"`
	NextToken  string        `json:"NextToken" xml:"NextToken"`
	MaxResults int           `json:"MaxResults" xml:"MaxResults"`
	TotalCount int           `json:"TotalCount" xml:"TotalCount"`
	Count      string        `json:"Count" xml:"Count"`
	QosList    []QosListItem `json:"QosList" xml:"QosList"`
}

// CreateDescribeExpressConnectTrafficQosRequest creates a request to invoke DescribeExpressConnectTrafficQos API
func CreateDescribeExpressConnectTrafficQosRequest() (request *DescribeExpressConnectTrafficQosRequest) {
	request = &DescribeExpressConnectTrafficQosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribeExpressConnectTrafficQos", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeExpressConnectTrafficQosResponse creates a response to parse from DescribeExpressConnectTrafficQos response
func CreateDescribeExpressConnectTrafficQosResponse() (response *DescribeExpressConnectTrafficQosResponse) {
	response = &DescribeExpressConnectTrafficQosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
