package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRouteEntries invokes the vpc.DeleteRouteEntries API synchronously
func (client *Client) DeleteRouteEntries(request *DeleteRouteEntriesRequest) (response *DeleteRouteEntriesResponse, err error) {
	response = CreateDeleteRouteEntriesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRouteEntriesWithChan invokes the vpc.DeleteRouteEntries API asynchronously
func (client *Client) DeleteRouteEntriesWithChan(request *DeleteRouteEntriesRequest) (<-chan *DeleteRouteEntriesResponse, <-chan error) {
	responseChan := make(chan *DeleteRouteEntriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRouteEntries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRouteEntriesWithCallback invokes the vpc.DeleteRouteEntries API asynchronously
func (client *Client) DeleteRouteEntriesWithCallback(request *DeleteRouteEntriesRequest, callback func(response *DeleteRouteEntriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRouteEntriesResponse
		var err error
		defer close(result)
		response, err = client.DeleteRouteEntries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRouteEntriesRequest is the request struct for api DeleteRouteEntries
type DeleteRouteEntriesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer                  `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string                            `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                            `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer                  `position:"Query" name:"OwnerId"`
	RouteEntries         *[]DeleteRouteEntriesRouteEntries `position:"Query" name:"RouteEntries"  type:"Repeated"`
}

// DeleteRouteEntriesRouteEntries is a repeated param struct in DeleteRouteEntriesRequest
type DeleteRouteEntriesRouteEntries struct {
	RouteTableId string `name:"RouteTableId"`
	RouteEntryId string `name:"RouteEntryId"`
	DstCidrBlock string `name:"DstCidrBlock"`
	NextHop      string `name:"NextHop"`
}

// DeleteRouteEntriesResponse is the response struct for api DeleteRouteEntries
type DeleteRouteEntriesResponse struct {
	*responses.BaseResponse
	RequestId          string                   `json:"RequestId" xml:"RequestId"`
	SuccessCount       int                      `json:"SuccessCount" xml:"SuccessCount"`
	FailedCount        int                      `json:"FailedCount" xml:"FailedCount"`
	FailedRouteEntries []FailedRouteEntriesItem `json:"FailedRouteEntries" xml:"FailedRouteEntries"`
}

// CreateDeleteRouteEntriesRequest creates a request to invoke DeleteRouteEntries API
func CreateDeleteRouteEntriesRequest() (request *DeleteRouteEntriesRequest) {
	request = &DeleteRouteEntriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteRouteEntries", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteRouteEntriesResponse creates a response to parse from DeleteRouteEntries response
func CreateDeleteRouteEntriesResponse() (response *DeleteRouteEntriesResponse) {
	response = &DeleteRouteEntriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
