package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateExpressCloudConnection invokes the vpc.CreateExpressCloudConnection API synchronously
func (client *Client) CreateExpressCloudConnection(request *CreateExpressCloudConnectionRequest) (response *CreateExpressCloudConnectionResponse, err error) {
	response = CreateCreateExpressCloudConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// CreateExpressCloudConnectionWithChan invokes the vpc.CreateExpressCloudConnection API asynchronously
func (client *Client) CreateExpressCloudConnectionWithChan(request *CreateExpressCloudConnectionRequest) (<-chan *CreateExpressCloudConnectionResponse, <-chan error) {
	responseChan := make(chan *CreateExpressCloudConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateExpressCloudConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateExpressCloudConnectionWithCallback invokes the vpc.CreateExpressCloudConnection API asynchronously
func (client *Client) CreateExpressCloudConnectionWithCallback(request *CreateExpressCloudConnectionRequest, callback func(response *CreateExpressCloudConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateExpressCloudConnectionResponse
		var err error
		defer close(result)
		response, err = client.CreateExpressCloudConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateExpressCloudConnectionRequest is the request struct for api CreateExpressCloudConnection
type CreateExpressCloudConnectionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PortType             string           `position:"Query" name:"PortType"`
	Description          string           `position:"Query" name:"Description"`
	RedundantEccId       string           `position:"Query" name:"RedundantEccId"`
	PeerLocation         string           `position:"Query" name:"PeerLocation"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	Bandwidth            requests.Integer `position:"Query" name:"Bandwidth"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	PeerCity             string           `position:"Query" name:"PeerCity"`
	IDCardNo             string           `position:"Query" name:"IDCardNo"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ContactMail          string           `position:"Query" name:"ContactMail"`
	ContactTel           string           `position:"Query" name:"ContactTel"`
	IdcSP                string           `position:"Query" name:"IdcSP"`
	Name                 string           `position:"Query" name:"Name"`
}

// CreateExpressCloudConnectionResponse is the response struct for api CreateExpressCloudConnection
type CreateExpressCloudConnectionResponse struct {
	*responses.BaseResponse
	EccId     string `json:"EccId" xml:"EccId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateExpressCloudConnectionRequest creates a request to invoke CreateExpressCloudConnection API
func CreateCreateExpressCloudConnectionRequest() (request *CreateExpressCloudConnectionRequest) {
	request = &CreateExpressCloudConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CreateExpressCloudConnection", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateExpressCloudConnectionResponse creates a response to parse from CreateExpressCloudConnection response
func CreateCreateExpressCloudConnectionResponse() (response *CreateExpressCloudConnectionResponse) {
	response = &CreateExpressCloudConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
