package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodDomainQpsData invokes the vod.DescribeVodDomainQpsData API synchronously
func (client *Client) DescribeVodDomainQpsData(request *DescribeVodDomainQpsDataRequest) (response *DescribeVodDomainQpsDataResponse, err error) {
	response = CreateDescribeVodDomainQpsDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodDomainQpsDataWithChan invokes the vod.DescribeVodDomainQpsData API asynchronously
func (client *Client) DescribeVodDomainQpsDataWithChan(request *DescribeVodDomainQpsDataRequest) (<-chan *DescribeVodDomainQpsDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVodDomainQpsDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodDomainQpsData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodDomainQpsDataWithCallback invokes the vod.DescribeVodDomainQpsData API asynchronously
func (client *Client) DescribeVodDomainQpsDataWithCallback(request *DescribeVodDomainQpsDataRequest, callback func(response *DescribeVodDomainQpsDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodDomainQpsDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodDomainQpsData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodDomainQpsDataRequest is the request struct for api DescribeVodDomainQpsData
type DescribeVodDomainQpsDataRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	IspNameEn      string           `position:"Query" name:"IspNameEn"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	Interval       string           `position:"Query" name:"Interval"`
}

// DescribeVodDomainQpsDataResponse is the response struct for api DescribeVodDomainQpsData
type DescribeVodDomainQpsDataResponse struct {
	*responses.BaseResponse
	EndTime         string          `json:"EndTime" xml:"EndTime"`
	StartTime       string          `json:"StartTime" xml:"StartTime"`
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	DomainName      string          `json:"DomainName" xml:"DomainName"`
	DataInterval    string          `json:"DataInterval" xml:"DataInterval"`
	QpsDataInterval QpsDataInterval `json:"QpsDataInterval" xml:"QpsDataInterval"`
}

// CreateDescribeVodDomainQpsDataRequest creates a request to invoke DescribeVodDomainQpsData API
func CreateDescribeVodDomainQpsDataRequest() (request *DescribeVodDomainQpsDataRequest) {
	request = &DescribeVodDomainQpsDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodDomainQpsData", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVodDomainQpsDataResponse creates a response to parse from DescribeVodDomainQpsData response
func CreateDescribeVodDomainQpsDataResponse() (response *DescribeVodDomainQpsDataResponse) {
	response = &DescribeVodDomainQpsDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
