package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchStopVodDomain invokes the vod.BatchStopVodDomain API synchronously
func (client *Client) BatchStopVodDomain(request *BatchStopVodDomainRequest) (response *BatchStopVodDomainResponse, err error) {
	response = CreateBatchStopVodDomainResponse()
	err = client.DoAction(request, response)
	return
}

// BatchStopVodDomainWithChan invokes the vod.BatchStopVodDomain API asynchronously
func (client *Client) BatchStopVodDomainWithChan(request *BatchStopVodDomainRequest) (<-chan *BatchStopVodDomainResponse, <-chan error) {
	responseChan := make(chan *BatchStopVodDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchStopVodDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchStopVodDomainWithCallback invokes the vod.BatchStopVodDomain API asynchronously
func (client *Client) BatchStopVodDomainWithCallback(request *BatchStopVodDomainRequest, callback func(response *BatchStopVodDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchStopVodDomainResponse
		var err error
		defer close(result)
		response, err = client.BatchStopVodDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchStopVodDomainRequest is the request struct for api BatchStopVodDomain
type BatchStopVodDomainRequest struct {
	*requests.RpcRequest
	DomainNames   string           `position:"Query" name:"DomainNames"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// BatchStopVodDomainResponse is the response struct for api BatchStopVodDomain
type BatchStopVodDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBatchStopVodDomainRequest creates a request to invoke BatchStopVodDomain API
func CreateBatchStopVodDomainRequest() (request *BatchStopVodDomainRequest) {
	request = &BatchStopVodDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "BatchStopVodDomain", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchStopVodDomainResponse creates a response to parse from BatchStopVodDomain response
func CreateBatchStopVodDomainResponse() (response *BatchStopVodDomainResponse) {
	response = &BatchStopVodDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
