package videosearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddDeletionVideoTask invokes the videosearch.AddDeletionVideoTask API synchronously
// api document: https://help.aliyun.com/api/videosearch/adddeletionvideotask.html
func (client *Client) AddDeletionVideoTask(request *AddDeletionVideoTaskRequest) (response *AddDeletionVideoTaskResponse, err error) {
	response = CreateAddDeletionVideoTaskResponse()
	err = client.DoAction(request, response)
	return
}

// AddDeletionVideoTaskWithChan invokes the videosearch.AddDeletionVideoTask API asynchronously
// api document: https://help.aliyun.com/api/videosearch/adddeletionvideotask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddDeletionVideoTaskWithChan(request *AddDeletionVideoTaskRequest) (<-chan *AddDeletionVideoTaskResponse, <-chan error) {
	responseChan := make(chan *AddDeletionVideoTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddDeletionVideoTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddDeletionVideoTaskWithCallback invokes the videosearch.AddDeletionVideoTask API asynchronously
// api document: https://help.aliyun.com/api/videosearch/adddeletionvideotask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddDeletionVideoTaskWithCallback(request *AddDeletionVideoTaskRequest, callback func(response *AddDeletionVideoTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddDeletionVideoTaskResponse
		var err error
		defer close(result)
		response, err = client.AddDeletionVideoTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddDeletionVideoTaskRequest is the request struct for api AddDeletionVideoTask
type AddDeletionVideoTaskRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	VideoId     string `position:"Body" name:"VideoId"`
	InstanceId  string `position:"Body" name:"InstanceId"`
}

// AddDeletionVideoTaskResponse is the response struct for api AddDeletionVideoTask
type AddDeletionVideoTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateAddDeletionVideoTaskRequest creates a request to invoke AddDeletionVideoTask API
func CreateAddDeletionVideoTaskRequest() (request *AddDeletionVideoTaskRequest) {
	request = &AddDeletionVideoTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("videosearch", "2020-02-25", "AddDeletionVideoTask", "", "")
	request.Method = requests.POST
	return
}

// CreateAddDeletionVideoTaskResponse creates a response to parse from AddDeletionVideoTask response
func CreateAddDeletionVideoTaskResponse() (response *AddDeletionVideoTaskResponse) {
	response = &AddDeletionVideoTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
