package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDefaultDatabase invokes the ververica.GetDefaultDatabase API synchronously
func (client *Client) GetDefaultDatabase(request *GetDefaultDatabaseRequest) (response *GetDefaultDatabaseResponse, err error) {
	response = CreateGetDefaultDatabaseResponse()
	err = client.DoAction(request, response)
	return
}

// GetDefaultDatabaseWithChan invokes the ververica.GetDefaultDatabase API asynchronously
func (client *Client) GetDefaultDatabaseWithChan(request *GetDefaultDatabaseRequest) (<-chan *GetDefaultDatabaseResponse, <-chan error) {
	responseChan := make(chan *GetDefaultDatabaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDefaultDatabase(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDefaultDatabaseWithCallback invokes the ververica.GetDefaultDatabase API asynchronously
func (client *Client) GetDefaultDatabaseWithCallback(request *GetDefaultDatabaseRequest, callback func(response *GetDefaultDatabaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDefaultDatabaseResponse
		var err error
		defer close(result)
		response, err = client.GetDefaultDatabase(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDefaultDatabaseRequest is the request struct for api GetDefaultDatabase
type GetDefaultDatabaseRequest struct {
	*requests.RoaRequest
	Workspace string `position:"Path" name:"workspace"`
	Cat       string `position:"Path" name:"cat"`
	Namespace string `position:"Path" name:"namespace"`
}

// GetDefaultDatabaseResponse is the response struct for api GetDefaultDatabase
type GetDefaultDatabaseResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	Data      string `json:"data" xml:"data"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateGetDefaultDatabaseRequest creates a request to invoke GetDefaultDatabase API
func CreateGetDefaultDatabaseRequest() (request *GetDefaultDatabaseRequest) {
	request = &GetDefaultDatabaseRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "GetDefaultDatabase", "/pop/workspaces/[workspace]/catalog/v1beta2/namespaces/[namespace]/catalogs/[cat]:getDefaultDatabase", "", "")
	request.Method = requests.GET
	return
}

// CreateGetDefaultDatabaseResponse creates a response to parse from GetDefaultDatabase response
func CreateGetDefaultDatabaseResponse() (response *GetDefaultDatabaseResponse) {
	response = &GetDefaultDatabaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
