package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateProfile invokes the vcs.UpdateProfile API synchronously
func (client *Client) UpdateProfile(request *UpdateProfileRequest) (response *UpdateProfileResponse, err error) {
	response = CreateUpdateProfileResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateProfileWithChan invokes the vcs.UpdateProfile API asynchronously
func (client *Client) UpdateProfileWithChan(request *UpdateProfileRequest) (<-chan *UpdateProfileResponse, <-chan error) {
	responseChan := make(chan *UpdateProfileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateProfile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateProfileWithCallback invokes the vcs.UpdateProfile API asynchronously
func (client *Client) UpdateProfileWithCallback(request *UpdateProfileRequest, callback func(response *UpdateProfileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateProfileResponse
		var err error
		defer close(result)
		response, err = client.UpdateProfile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateProfileRequest is the request struct for api UpdateProfile
type UpdateProfileRequest struct {
	*requests.RpcRequest
	CorpId      string           `position:"Body" name:"CorpId"`
	Gender      requests.Integer `position:"Body" name:"Gender"`
	PlateNo     string           `position:"Body" name:"PlateNo"`
	IdNumber    string           `position:"Body" name:"IdNumber"`
	FaceUrl     string           `position:"Body" name:"FaceUrl"`
	ProfileId   requests.Integer `position:"Body" name:"ProfileId"`
	LiveAddress string           `position:"Body" name:"LiveAddress"`
	IsvSubId    string           `position:"Body" name:"IsvSubId"`
	SceneType   string           `position:"Body" name:"SceneType"`
	PhoneNo     string           `position:"Body" name:"PhoneNo"`
	CatalogId   requests.Integer `position:"Body" name:"CatalogId"`
	Name        string           `position:"Body" name:"Name"`
	BizId       string           `position:"Body" name:"BizId"`
}

// UpdateProfileResponse is the response struct for api UpdateProfile
type UpdateProfileResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateProfileRequest creates a request to invoke UpdateProfile API
func CreateUpdateProfileRequest() (request *UpdateProfileRequest) {
	request = &UpdateProfileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "UpdateProfile", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateProfileResponse creates a response to parse from UpdateProfile response
func CreateUpdateProfileResponse() (response *UpdateProfileResponse) {
	response = &UpdateProfileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
