package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMetrics invokes the vcs.ListMetrics API synchronously
func (client *Client) ListMetrics(request *ListMetricsRequest) (response *ListMetricsResponse, err error) {
	response = CreateListMetricsResponse()
	err = client.DoAction(request, response)
	return
}

// ListMetricsWithChan invokes the vcs.ListMetrics API asynchronously
func (client *Client) ListMetricsWithChan(request *ListMetricsRequest) (<-chan *ListMetricsResponse, <-chan error) {
	responseChan := make(chan *ListMetricsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMetrics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMetricsWithCallback invokes the vcs.ListMetrics API asynchronously
func (client *Client) ListMetricsWithCallback(request *ListMetricsRequest, callback func(response *ListMetricsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMetricsResponse
		var err error
		defer close(result)
		response, err = client.ListMetrics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMetricsRequest is the request struct for api ListMetrics
type ListMetricsRequest struct {
	*requests.RpcRequest
	CorpId        string `position:"Body" name:"CorpId"`
	EndTime       string `position:"Body" name:"EndTime"`
	StartTime     string `position:"Body" name:"StartTime"`
	PageNumber    string `position:"Body" name:"PageNumber"`
	TagCode       string `position:"Body" name:"TagCode"`
	PageSize      string `position:"Body" name:"PageSize"`
	AggregateType string `position:"Body" name:"AggregateType"`
}

// ListMetricsResponse is the response struct for api ListMetrics
type ListMetricsResponse struct {
	*responses.BaseResponse
	Code      string            `json:"Code" xml:"Code"`
	Message   string            `json:"Message" xml:"Message"`
	RequestId string            `json:"RequestId" xml:"RequestId"`
	Data      DataInListMetrics `json:"Data" xml:"Data"`
}

// CreateListMetricsRequest creates a request to invoke ListMetrics API
func CreateListMetricsRequest() (request *ListMetricsRequest) {
	request = &ListMetricsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "ListMetrics", "", "")
	request.Method = requests.POST
	return
}

// CreateListMetricsResponse creates a response to parse from ListMetrics response
func CreateListMetricsResponse() (response *ListMetricsResponse) {
	response = &ListMetricsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
