package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddProfile invokes the vcs.AddProfile API synchronously
func (client *Client) AddProfile(request *AddProfileRequest) (response *AddProfileResponse, err error) {
	response = CreateAddProfileResponse()
	err = client.DoAction(request, response)
	return
}

// AddProfileWithChan invokes the vcs.AddProfile API asynchronously
func (client *Client) AddProfileWithChan(request *AddProfileRequest) (<-chan *AddProfileResponse, <-chan error) {
	responseChan := make(chan *AddProfileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddProfile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddProfileWithCallback invokes the vcs.AddProfile API asynchronously
func (client *Client) AddProfileWithCallback(request *AddProfileRequest, callback func(response *AddProfileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddProfileResponse
		var err error
		defer close(result)
		response, err = client.AddProfile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddProfileRequest is the request struct for api AddProfile
type AddProfileRequest struct {
	*requests.RpcRequest
	CorpId      string           `position:"Body" name:"CorpId"`
	Gender      requests.Integer `position:"Body" name:"Gender"`
	PlateNo     string           `position:"Body" name:"PlateNo"`
	IdNumber    string           `position:"Body" name:"IdNumber"`
	FaceUrl     string           `position:"Body" name:"FaceUrl"`
	LiveAddress string           `position:"Body" name:"LiveAddress"`
	IsvSubId    string           `position:"Body" name:"IsvSubId"`
	SceneType   string           `position:"Body" name:"SceneType"`
	PhoneNo     string           `position:"Body" name:"PhoneNo"`
	CatalogId   requests.Integer `position:"Body" name:"CatalogId"`
	Name        string           `position:"Body" name:"Name"`
	BizId       string           `position:"Body" name:"BizId"`
}

// AddProfileResponse is the response struct for api AddProfile
type AddProfileResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAddProfileRequest creates a request to invoke AddProfile API
func CreateAddProfileRequest() (request *AddProfileRequest) {
	request = &AddProfileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "AddProfile", "", "")
	request.Method = requests.POST
	return
}

// CreateAddProfileResponse creates a response to parse from AddProfile response
func CreateAddProfileResponse() (response *AddProfileResponse) {
	response = &AddProfileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
