package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTradeProduceDetail invokes the trademark.QueryTradeProduceDetail API synchronously
// api document: https://help.aliyun.com/api/trademark/querytradeproducedetail.html
func (client *Client) QueryTradeProduceDetail(request *QueryTradeProduceDetailRequest) (response *QueryTradeProduceDetailResponse, err error) {
	response = CreateQueryTradeProduceDetailResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTradeProduceDetailWithChan invokes the trademark.QueryTradeProduceDetail API asynchronously
// api document: https://help.aliyun.com/api/trademark/querytradeproducedetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTradeProduceDetailWithChan(request *QueryTradeProduceDetailRequest) (<-chan *QueryTradeProduceDetailResponse, <-chan error) {
	responseChan := make(chan *QueryTradeProduceDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTradeProduceDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTradeProduceDetailWithCallback invokes the trademark.QueryTradeProduceDetail API asynchronously
// api document: https://help.aliyun.com/api/trademark/querytradeproducedetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTradeProduceDetailWithCallback(request *QueryTradeProduceDetailRequest, callback func(response *QueryTradeProduceDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTradeProduceDetailResponse
		var err error
		defer close(result)
		response, err = client.QueryTradeProduceDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTradeProduceDetailRequest is the request struct for api QueryTradeProduceDetail
type QueryTradeProduceDetailRequest struct {
	*requests.RpcRequest
	BizId string `position:"Query" name:"BizId"`
}

// QueryTradeProduceDetailResponse is the response struct for api QueryTradeProduceDetail
type QueryTradeProduceDetailResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryTradeProduceDetailRequest creates a request to invoke QueryTradeProduceDetail API
func CreateQueryTradeProduceDetailRequest() (request *QueryTradeProduceDetailRequest) {
	request = &QueryTradeProduceDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "QueryTradeProduceDetail", "trademark", "openAPI")
	return
}

// CreateQueryTradeProduceDetailResponse creates a response to parse from QueryTradeProduceDetail response
func CreateQueryTradeProduceDetailResponse() (response *QueryTradeProduceDetailResponse) {
	response = &QueryTradeProduceDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
