package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFirewallTemplateRulesApplyResult invokes the swas_open.DescribeFirewallTemplateRulesApplyResult API synchronously
func (client *Client) DescribeFirewallTemplateRulesApplyResult(request *DescribeFirewallTemplateRulesApplyResultRequest) (response *DescribeFirewallTemplateRulesApplyResultResponse, err error) {
	response = CreateDescribeFirewallTemplateRulesApplyResultResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFirewallTemplateRulesApplyResultWithChan invokes the swas_open.DescribeFirewallTemplateRulesApplyResult API asynchronously
func (client *Client) DescribeFirewallTemplateRulesApplyResultWithChan(request *DescribeFirewallTemplateRulesApplyResultRequest) (<-chan *DescribeFirewallTemplateRulesApplyResultResponse, <-chan error) {
	responseChan := make(chan *DescribeFirewallTemplateRulesApplyResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFirewallTemplateRulesApplyResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFirewallTemplateRulesApplyResultWithCallback invokes the swas_open.DescribeFirewallTemplateRulesApplyResult API asynchronously
func (client *Client) DescribeFirewallTemplateRulesApplyResultWithCallback(request *DescribeFirewallTemplateRulesApplyResultRequest, callback func(response *DescribeFirewallTemplateRulesApplyResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFirewallTemplateRulesApplyResultResponse
		var err error
		defer close(result)
		response, err = client.DescribeFirewallTemplateRulesApplyResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFirewallTemplateRulesApplyResultRequest is the request struct for api DescribeFirewallTemplateRulesApplyResult
type DescribeFirewallTemplateRulesApplyResultRequest struct {
	*requests.RpcRequest
	FirewallTemplateId string `position:"Query" name:"FirewallTemplateId"`
	ClientToken        string `position:"Query" name:"ClientToken"`
	InstanceId         string `position:"Query" name:"InstanceId"`
	TaskId             string `position:"Query" name:"TaskId"`
}

// DescribeFirewallTemplateRulesApplyResultResponse is the response struct for api DescribeFirewallTemplateRulesApplyResult
type DescribeFirewallTemplateRulesApplyResultResponse struct {
	*responses.BaseResponse
	RequestId string                                     `json:"RequestId" xml:"RequestId"`
	Data      []InstanceApplyFirewallTemplateRulesResult `json:"data" xml:"data"`
}

// CreateDescribeFirewallTemplateRulesApplyResultRequest creates a request to invoke DescribeFirewallTemplateRulesApplyResult API
func CreateDescribeFirewallTemplateRulesApplyResultRequest() (request *DescribeFirewallTemplateRulesApplyResultRequest) {
	request = &DescribeFirewallTemplateRulesApplyResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "DescribeFirewallTemplateRulesApplyResult", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeFirewallTemplateRulesApplyResultResponse creates a response to parse from DescribeFirewallTemplateRulesApplyResult response
func CreateDescribeFirewallTemplateRulesApplyResultResponse() (response *DescribeFirewallTemplateRulesApplyResultResponse) {
	response = &DescribeFirewallTemplateRulesApplyResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
