package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFirewallRules invokes the swas_open.CreateFirewallRules API synchronously
func (client *Client) CreateFirewallRules(request *CreateFirewallRulesRequest) (response *CreateFirewallRulesResponse, err error) {
	response = CreateCreateFirewallRulesResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFirewallRulesWithChan invokes the swas_open.CreateFirewallRules API asynchronously
func (client *Client) CreateFirewallRulesWithChan(request *CreateFirewallRulesRequest) (<-chan *CreateFirewallRulesResponse, <-chan error) {
	responseChan := make(chan *CreateFirewallRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFirewallRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFirewallRulesWithCallback invokes the swas_open.CreateFirewallRules API asynchronously
func (client *Client) CreateFirewallRulesWithCallback(request *CreateFirewallRulesRequest, callback func(response *CreateFirewallRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFirewallRulesResponse
		var err error
		defer close(result)
		response, err = client.CreateFirewallRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFirewallRulesRequest is the request struct for api CreateFirewallRules
type CreateFirewallRulesRequest struct {
	*requests.RpcRequest
	ClientToken   string                              `position:"Query" name:"ClientToken"`
	InstanceId    string                              `position:"Query" name:"InstanceId"`
	FirewallRules *[]CreateFirewallRulesFirewallRules `position:"Query" name:"FirewallRules"  type:"Json"`
	Tag           *[]CreateFirewallRulesTag           `position:"Query" name:"Tag"  type:"Repeated"`
}

// CreateFirewallRulesFirewallRules is a repeated param struct in CreateFirewallRulesRequest
type CreateFirewallRulesFirewallRules struct {
	RuleProtocol string `name:"RuleProtocol"`
	Port         string `name:"Port"`
	SourceCidrIp string `name:"SourceCidrIp"`
	Remark       string `name:"Remark"`
}

// CreateFirewallRulesTag is a repeated param struct in CreateFirewallRulesRequest
type CreateFirewallRulesTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// CreateFirewallRulesResponse is the response struct for api CreateFirewallRules
type CreateFirewallRulesResponse struct {
	*responses.BaseResponse
	RequestId       string   `json:"RequestId" xml:"RequestId"`
	FirewallRuleIds []string `json:"FirewallRuleIds" xml:"FirewallRuleIds"`
}

// CreateCreateFirewallRulesRequest creates a request to invoke CreateFirewallRules API
func CreateCreateFirewallRulesRequest() (request *CreateFirewallRulesRequest) {
	request = &CreateFirewallRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "CreateFirewallRules", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateFirewallRulesResponse creates a response to parse from CreateFirewallRules response
func CreateCreateFirewallRulesResponse() (response *CreateFirewallRulesResponse) {
	response = &CreateFirewallRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
