package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReportGatewayUsage invokes the sgw.ReportGatewayUsage API synchronously
func (client *Client) ReportGatewayUsage(request *ReportGatewayUsageRequest) (response *ReportGatewayUsageResponse, err error) {
	response = CreateReportGatewayUsageResponse()
	err = client.DoAction(request, response)
	return
}

// ReportGatewayUsageWithChan invokes the sgw.ReportGatewayUsage API asynchronously
func (client *Client) ReportGatewayUsageWithChan(request *ReportGatewayUsageRequest) (<-chan *ReportGatewayUsageResponse, <-chan error) {
	responseChan := make(chan *ReportGatewayUsageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReportGatewayUsage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReportGatewayUsageWithCallback invokes the sgw.ReportGatewayUsage API asynchronously
func (client *Client) ReportGatewayUsageWithCallback(request *ReportGatewayUsageRequest, callback func(response *ReportGatewayUsageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReportGatewayUsageResponse
		var err error
		defer close(result)
		response, err = client.ReportGatewayUsage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReportGatewayUsageRequest is the request struct for api ReportGatewayUsage
type ReportGatewayUsageRequest struct {
	*requests.RpcRequest
	ClientUUID    string `position:"Query" name:"ClientUUID"`
	Usage         string `position:"Query" name:"Usage"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// ReportGatewayUsageResponse is the response struct for api ReportGatewayUsage
type ReportGatewayUsageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateReportGatewayUsageRequest creates a request to invoke ReportGatewayUsage API
func CreateReportGatewayUsageRequest() (request *ReportGatewayUsageRequest) {
	request = &ReportGatewayUsageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "ReportGatewayUsage", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReportGatewayUsageResponse creates a response to parse from ReportGatewayUsage response
func CreateReportGatewayUsageResponse() (response *ReportGatewayUsageResponse) {
	response = &ReportGatewayUsageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
