package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGateway invokes the sgw.DescribeGateway API synchronously
func (client *Client) DescribeGateway(request *DescribeGatewayRequest) (response *DescribeGatewayResponse, err error) {
	response = CreateDescribeGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGatewayWithChan invokes the sgw.DescribeGateway API asynchronously
func (client *Client) DescribeGatewayWithChan(request *DescribeGatewayRequest) (<-chan *DescribeGatewayResponse, <-chan error) {
	responseChan := make(chan *DescribeGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGatewayWithCallback invokes the sgw.DescribeGateway API asynchronously
func (client *Client) DescribeGatewayWithCallback(request *DescribeGatewayRequest, callback func(response *DescribeGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGatewayResponse
		var err error
		defer close(result)
		response, err = client.DescribeGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGatewayRequest is the request struct for api DescribeGateway
type DescribeGatewayRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// DescribeGatewayResponse is the response struct for api DescribeGateway
type DescribeGatewayResponse struct {
	*responses.BaseResponse
	RequestId                string                        `json:"RequestId" xml:"RequestId"`
	Success                  bool                          `json:"Success" xml:"Success"`
	Code                     string                        `json:"Code" xml:"Code"`
	Message                  string                        `json:"Message" xml:"Message"`
	GatewayId                string                        `json:"GatewayId" xml:"GatewayId"`
	StorageBundleId          string                        `json:"StorageBundleId" xml:"StorageBundleId"`
	Name                     string                        `json:"Name" xml:"Name"`
	Description              string                        `json:"Description" xml:"Description"`
	Location                 string                        `json:"Location" xml:"Location"`
	Category                 string                        `json:"Category" xml:"Category"`
	Type                     string                        `json:"Type" xml:"Type"`
	GatewayClass             string                        `json:"GatewayClass" xml:"GatewayClass"`
	Model                    string                        `json:"Model" xml:"Model"`
	SerialNumber             string                        `json:"SerialNumber" xml:"SerialNumber"`
	Status                   string                        `json:"Status" xml:"Status"`
	EcsInstanceId            string                        `json:"EcsInstanceId" xml:"EcsInstanceId"`
	VpcId                    string                        `json:"VpcId" xml:"VpcId"`
	VSwitchId                string                        `json:"VSwitchId" xml:"VSwitchId"`
	Ip                       string                        `json:"Ip" xml:"Ip"`
	InnerIp                  string                        `json:"InnerIp" xml:"InnerIp"`
	CreatedTime              int64                         `json:"CreatedTime" xml:"CreatedTime"`
	ActivatedTime            int64                         `json:"ActivatedTime" xml:"ActivatedTime"`
	TaskId                   string                        `json:"TaskId" xml:"TaskId"`
	GatewayVersion           string                        `json:"GatewayVersion" xml:"GatewayVersion"`
	BuyURL                   string                        `json:"BuyURL" xml:"BuyURL"`
	RenewURL                 string                        `json:"RenewURL" xml:"RenewURL"`
	IsPostPaid               bool                          `json:"IsPostPaid" xml:"IsPostPaid"`
	IsReleaseAfterExpiration bool                          `json:"IsReleaseAfterExpiration" xml:"IsReleaseAfterExpiration"`
	ExpiredTime              int64                         `json:"ExpiredTime" xml:"ExpiredTime"`
	ExpireStatus             int                           `json:"ExpireStatus" xml:"ExpireStatus"`
	CommonBuyInstanceId      string                        `json:"CommonBuyInstanceId" xml:"CommonBuyInstanceId"`
	PublicNetworkBandwidth   int                           `json:"PublicNetworkBandwidth" xml:"PublicNetworkBandwidth"`
	GatewayType              string                        `json:"GatewayType" xml:"GatewayType"`
	ElasticGateway           bool                          `json:"ElasticGateway" xml:"ElasticGateway"`
	MaxThroughput            int                           `json:"MaxThroughput" xml:"MaxThroughput"`
	Capacity                 int                           `json:"Capacity" xml:"Capacity"`
	DataLoadType             string                        `json:"DataLoadType" xml:"DataLoadType"`
	DataLoadInterval         int                           `json:"DataLoadInterval" xml:"DataLoadInterval"`
	LastErrorKey             string                        `json:"LastErrorKey" xml:"LastErrorKey"`
	InnerIpv6Ip              string                        `json:"InnerIpv6Ip" xml:"InnerIpv6Ip"`
	ElasticNodes             ElasticNodesInDescribeGateway `json:"ElasticNodes" xml:"ElasticNodes"`
}

// CreateDescribeGatewayRequest creates a request to invoke DescribeGateway API
func CreateDescribeGatewayRequest() (request *DescribeGatewayRequest) {
	request = &DescribeGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeGateway", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGatewayResponse creates a response to parse from DescribeGateway response
func CreateDescribeGatewayResponse() (response *DescribeGatewayResponse) {
	response = &DescribeGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
