package selectdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateElasticRule invokes the selectdb.CreateElasticRule API synchronously
func (client *Client) CreateElasticRule(request *CreateElasticRuleRequest) (response *CreateElasticRuleResponse, err error) {
	response = CreateCreateElasticRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateElasticRuleWithChan invokes the selectdb.CreateElasticRule API asynchronously
func (client *Client) CreateElasticRuleWithChan(request *CreateElasticRuleRequest) (<-chan *CreateElasticRuleResponse, <-chan error) {
	responseChan := make(chan *CreateElasticRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateElasticRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateElasticRuleWithCallback invokes the selectdb.CreateElasticRule API asynchronously
func (client *Client) CreateElasticRuleWithCallback(request *CreateElasticRuleRequest, callback func(response *CreateElasticRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateElasticRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateElasticRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateElasticRuleRequest is the request struct for api CreateElasticRule
type CreateElasticRuleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ExecutionPeriod      string           `position:"Query" name:"ExecutionPeriod"`
	ClusterId            string           `position:"Query" name:"ClusterId"`
	ElasticRuleStartTime string           `position:"Query" name:"ElasticRuleStartTime"`
	ClusterClass         string           `position:"Query" name:"ClusterClass"`
	DbInstanceId         string           `position:"Query" name:"DbInstanceId"`
}

// CreateElasticRuleResponse is the response struct for api CreateElasticRule
type CreateElasticRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateElasticRuleRequest creates a request to invoke CreateElasticRule API
func CreateCreateElasticRuleRequest() (request *CreateElasticRuleRequest) {
	request = &CreateElasticRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("selectdb", "2023-05-22", "CreateElasticRule", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateElasticRuleResponse creates a response to parse from CreateElasticRule response
func CreateCreateElasticRuleResponse() (response *CreateElasticRuleResponse) {
	response = &CreateElasticRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
